-- $Id: commonstringutilities.ads 12319 2009-01-28 12:49:09Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--# inherit Ada.Characters.Latin_1,
--#         CommonString;

package CommonStringUtilities
is

   type OrderTypes is (FirstOneFirst, SecondOneFirst, NeitherFirst);

   -- Section returns the specified subsection of the string
   -- if the subsection lies outside the string, empty string returned
   procedure Section (StrIn     : in     String;
                      StrLenIn  : in     Integer;
                      StartPos  : in     Integer;
                      Length    : in     Integer;
                      StrOut    :    out String;
                      StrLenOut :    out Integer);
   --# derives StrLenOut from Length,
   --#                        StartPos,
   --#                        StrLenIn &
   --#         StrOut    from Length,
   --#                        StartPos,
   --#                        StrIn,
   --#                        StrLenIn;

   -- Trim removes ' ', Latin_1.HT, Latin_1.LF, Latin_1.CR from either end of the string
   procedure Trim (StrIn  : in     String;
                   LenIn  : in     Integer;
                   StrOut :    out String;
                   LenOut :    out Integer);
   --# derives LenOut,
   --#         StrOut from LenIn,
   --#                     StrIn;

   -- FindSubStringAfter finds the specified SearchString, starting
   -- at the specified position in the given String
   procedure FindSubStringAfter (Str          : in     String;
                                 Len          : in     Integer;
                                 SearchStart  : in     Integer;
                                 SearchString : in     String;
                                 SearchStrLen : in     Integer;
                                 StringFound  :    out Boolean;
                                 StringStart  :    out Integer);
   --# derives StringFound,
   --#         StringStart from Len,
   --#                          SearchStart,
   --#                          SearchString,
   --#                          SearchStrLen,
   --#                          Str;

   -- FindCharAfter finds specified character in Str, starting at specified
   -- position
   procedure FindCharAfter (Str         : in     String;
                            Len         : in     Integer;
                            SearchStart : in     Integer;
                            SearchChar  : in     Character;
                            CharFound   :    out Boolean;
                            CharPos     :    out Integer);
   --# derives CharFound,
   --#         CharPos   from Len,
   --#                        SearchChar,
   --#                        SearchStart,
   --#                        Str;

   function LexOrder (FirstName  : String;
                      FirstLen   : Integer;
                      SecondName : String;
                      SecondLen  : Integer) return OrderTypes;

end CommonStringUtilities;
