-- $Id: commonstring.ads 12319 2009-01-28 12:49:09Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SPARK_IO;

--# inherit Ada.Characters.Handling,
--#         SPARK_IO;

package CommonString
is

   procedure InitString (S : out String);
   --# derives S from ;

   procedure LowerCase (Str    : in     String;
                        Len    : in     Natural;
                        StrOut :    out String);
   --# derives StrOut from Len,
   --#                     Str;

   procedure UpperCase (Str    : in     String;
                        Len    : in     Natural;
                        StrOut :    out String);
   --# derives StrOut from Len,
   --#                     Str;

   function EqString (Str1    : String;
                      Length1 : Natural;
                      Str2    : String;
                      Length2 : Natural) return Boolean;

   procedure CopyString (StrOut :    out String;
                         Length :    out Natural;
                         StrIn  : in     String);
   --# derives Length,
   --#         StrOut from StrIn;

   -- Append Str2 to Str1, putting the result in Str2.
   -- Len1 and Len2 give the lengths of each string. The
   -- result must fit into String'Length or overflow will occur.
   procedure AppendString (Str1 : in out String;
                           Len1 : in out Natural;
                           Str2 : in     String;
                           Len2 : in     Natural);
   --# derives Len1 from *,
   --#                   Len2 &
   --#         Str1 from *,
   --#                   Len1,
   --#                   Len2,
   --#                   Str2;

   -- Append Str2 to Str1, putting the result in Str2.
   -- Len1 and Len2 give the lengths of each string.
   -- If the result doesn't fit then it is truncated.
   procedure AppendStringTruncate (Str1 : in out String;
                                   Len1 : in out Natural;
                                   Str2 : in     String;
                                   Len2 : in     Natural);
   --# derives Len1 from *,
   --#                   Len2,
   --#                   Str1 &
   --#         Str1 from *,
   --#                   Len1,
   --#                   Len2,
   --#                   Str2;

   procedure PutString (File : in SPARK_IO.File_Type;
                        Str  : in String;
                        Len  : in Natural);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Len,
   --#                                Str;

   procedure PutLine (File : in SPARK_IO.File_Type;
                      Str  : in String;
                      Len  : in Natural);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Len,
   --#                                Str;

   procedure GetLine (File : in     SPARK_IO.File_Type;
                      Str  :    out String;
                      Len  :    out Natural);
   --# global in out SPARK_IO.File_Sys;
   --# derives Len,
   --#         SPARK_IO.File_Sys,
   --#         Str               from File,
   --#                                SPARK_IO.File_Sys;


   procedure AppendChar (Str     : in out String;
                         Len     : in out Natural;
                         Ch      : in     Character;
                         Success :    out Boolean);
   --# derives Len,
   --#         Success from Len,
   --#                      Str &
   --#         Str     from *,
   --#                      Ch,
   --#                      Len;

   -- PopChar takes as input an ExaminerString.  It removes the first character
   -- from the string and returns it in the Char output parameter.  If the empty
   -- string is passed in then the outputs are:
   --    EStr = EmptyString
   --    Char = ' '
   procedure PopChar (Str  : in out String;
                      Len  : in out Natural;
                      Char :    out Character);
   --# derives Char from Len,
   --#                   Str &
   --#         Len,
   --#         Str  from *,
   --#                   Len;

end CommonString;
