-- $Id: commandlinehandler.ads 11740 2008-11-21 10:00:15Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with ExaminerConstants,
     EStrings;

use type EStrings.T;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         CommandLineData,
--#         EStrings,
--#         ExaminerConstants,
--#         FileSystem,
--#         ScreenEcho,
--#         SPARK_IO,
--#         StringUtilities;

package CommandLineHandler
is

   subtype CommandStringPositions is Integer range
      1 .. ExaminerConstants.MaxCommandStringLength;

   subtype CommandStringContents is String (CommandStringPositions);

   type CommandStrings is record
      CurrentPosition : Positive;
      Contents        : CommandStringContents;
   end record;

   type STyps is (SEmpty, SEqual, SSlash, SComma, SString, SContinue);
   type Symbols is
      record
         Typ : STyps;
         TheString  : EStrings.T;
      end record;

   procedure PutError (S : in String);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                S;

   procedure PutWarning (S : in String);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                S;

   -- Copies F to T starting from position  T (StartFrom) in T.
   -- T (T'First .. StartFrom-1) are left unchanged.
   -- If T is not long enough, F is truncated as it is copied.
   procedure CopyString (F         : in     String;
                         StartFrom : in     Positive;
                         T         : in out String);
   --# derives T from *,
   --#                F,
   --#                StartFrom;

   procedure CheckOptionName (OptName : in     EStrings.T;
                              Str     : in     String;
                              OK      :    out Boolean);
   --# derives OK from OptName,
   --#                 Str;

   procedure SkipSpaces (CommandString : in out CommandStrings);
   --# derives CommandString from *;

   procedure ReadTheString (CommandString : in out CommandStrings;
                            NextSymbol    : in out Symbols);
   --# derives CommandString,
   --#         NextSymbol    from *,
   --#                            CommandString;

   ----------------------------------------------------------------------------
   -- Reads the default switch file "spark.sw", then the user's
   -- command-line switches.  Parses these and sets the content
   -- of CommandLineData.Content appropriately.  Illegal or
   -- contradictory switches are detected and reported.
   --
   -- As a special case, if -noswitch has been given on the command-line,
   -- then the default switch file "spark.sw" is completely ignored.
   ----------------------------------------------------------------------------
   procedure Process;
   --# global in out CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --# derives CommandLineData.Content,
   --#         SPARK_IO.File_Sys       from CommandLineData.Content,
   --#                                      SPARK_IO.File_Sys;


   ----------------------------------------------------------------------------
   -- Reads and parses the default switch file, setting
   -- CommandLineData.Content as it goes, but doesn't
   -- check for existence or non-overlapping of
   -- input files.  Used by tools like SPARKFormat
   -- which want to be able to read the default switch
   -- file, but don't care if the index file(s) (and so on)
   -- don't actually exist.
   --
   -- As a special case, if -noswitch has been given on the command-line,
   -- then the default switch file "spark.sw" is completely ignored.
   ----------------------------------------------------------------------------
   procedure ProcessDefaultsFromSwitchFile;
   --# global in out CommandLineData.Content;
   --#        in out SPARK_IO.File_Sys;
   --# derives CommandLineData.Content,
   --#         SPARK_IO.File_Sys       from CommandLineData.Content,
   --#                                      SPARK_IO.File_Sys;

end CommandLineHandler;
