-- $Id: commandlinedata.ads 12952 2009-04-09 13:13:58Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings,
     ExaminerConstants;

--# inherit EStrings,
--#         ExaminerConstants,
--#         FileSystem,
--#         SPARK_IO;

package CommandLineData
--# own Content : CommandLineContents;
is
   MetaFileExtension : constant EStrings.T :=
      EStrings.T'(3,
                                      EStrings.Contents'('s', 'm', 'f', others => ' '));

   DEFAULT_INDEX_EXTENSION : constant EStrings.T :=
      EStrings.T'(3,
                                      EStrings.Contents'('i', 'd', 'x', others => ' '));

   DEFAULT_WARNING_EXTENSION : constant EStrings.T :=
      EStrings.T'(3,
                                      EStrings.Contents'('w', 'r', 'n', others => ' '));

   DEFAULT_DATA_EXTENSION : constant EStrings.T :=
      EStrings.T'(3,
                                      EStrings.Contents'('d', 'a', 't', others => ' '));

   DEFAULT_CONFIG_EXTENSION : constant EStrings.T :=
      EStrings.T'(3,
                                      EStrings.Contents'('c', 'f', 'g', others => ' '));

   type SourceFileEntry is record
      SourceFileName  : EStrings.T;
      Listing         : Boolean;
      ListingFileName : EStrings.T;
   end record;

   type RedTypes is record
      PFs,
      VCs,
      RTC,
      ExpChecks,
      RealRTCs     : Boolean;
   end record;
                                          --PFs,   VCs,   RTC,  ExpChecks Reals
   NoVCG   : constant RedTypes := RedTypes'(False, False, False, False, False);
   JustPFs : constant RedTypes := RedTypes'(True,  False, False, False, False);
   DoRtc   : constant RedTypes := RedTypes'(False, True,  True,  False, False);
   DoExp   : constant RedTypes := RedTypes'(False, True,  True,  True,  False);

   subtype SourceFileCounts is Integer range
      0 .. ExaminerConstants.MaxFilesOnCommandLine;
   subtype SourceFilePositions is Integer range
      0 .. ExaminerConstants.MaxFilesOnCommandLine;
   type SourceFileLists is array (SourceFilePositions) of SourceFileEntry;

   ---------------------------------------------------------------------
   -- To Add a new debug flag:
   --
   -- 1. Add a Boolean field to this record, and supply an initial value
   -- for it in the body of CommandLineData.Initialize
   --
   -- 2. Update CommandLineHandler.ParseCommandOptions to recognize
   -- and set the new flag.
   --
   -- 3. Document the new flag in the Examiner's help output in
   -- sparkmain.adb
   --
   -- 4. Document the new flag in the Examiner User Manual
   --
   -- 5. Test and use the flag to produce the output required
   ---------------------------------------------------------------------
   type DebugState is record
      Enabled       : Boolean;   -- any -debug flag is enabled.
      Expressions   : Boolean;   -- -debug=e - expression walk debugging
      HTML          : Boolean;   -- -debug=h - HTML generation debugging
      LookupTrace   : Boolean;   -- -debug=l - Dictionary look up call tracing
      FileNames     : Boolean;   -- -debug=f - Trace filename storage/open/create
      Units         : Boolean;   -- -debug=u - Trace required units and index lookup
      Invariants    : Boolean;   -- -debug=i - Print default loop invariants
      Components    : Boolean;   -- -debug=c - print state of component manager when
                                 --            adding subcomponents
      Rho           : Boolean;   -- -debug=r - Print computed Rho relation for subprograms
      Parser        : Boolean;   -- -debug=p - Print parser state on detection of syntax error
      FDL_Ranking   : Boolean;   -- -debug=k - trace ranking and printing of FDL declarations
      VCG           : Boolean;   -- -debug=v - print VCG state after DAG.BuildGraph
      VCG_All       : Boolean;   -- -debug=V - as VCG, but also print VCG state during each iteration
                                 --            of Graph.GenVCs
      DAG           : Boolean;   -- -debug=d - print FDL DAG following BuildExpnDAG
   end record;

   type AnalysisProfiles is (Sequential, Ravenscar);

   type InfoFlowPolicies is (None, Safety, Security);

   -- A subtype of the above excluding "None"
   subtype DefinedInfoFlowPolicies is InfoFlowPolicies range Safety .. InfoFlowPolicies'Last;

   type JustificationOptions is (Ignore, Full, Brief);

   -------------------------------------------------------------------------------------
   -- Proof rule generation policies for composite constants.  If this type
   -- changes, then the error message in CommandLineHandler.OutputError must be updated.
   --
   -- Whether a proof rule gets generated or not for a particular constant depends on
   -- the seeting of this switch, and the presence (or absence) of an object_assertion
   -- annotation for that constant.
   --
   -- The policies are as follows:
   --   NoRules  - NEVER  generate composite proof rules, regardless of annotations
   --   AllRules - ALWAYS generate composite proof rules, regardless of annotations
   --   Lazy     - Generate rules for constants where an annotation requests it.
   --              If no annotation is given then no rule is generated.
   --   Keen     - Generate rules for constants where an annotation requests it.
   --              If no annotation is given then a rule IS generated.
   -------------------------------------------------------------------------------------
   type RuleGenerationPolicies is (NoRules, Lazy, Keen, AllRules);

   type ErrorExplanations is (Off, FirstOccurrence, EveryOccurrence);

   type CommandLineContents is record
      Valid               : Boolean;

      Index               : Boolean;
      IndexFileName       : EStrings.T;

      Warning             : Boolean;
      WarningFileName     : EStrings.T;

      TargetData          : Boolean;
      TargetDataFile      : EStrings.T;

      TargetConfig        : Boolean;
      TargetConfigFile    : EStrings.T;

      SourceExtension     : EStrings.T;
      NumberSource        : SourceFileCounts;
      SourceFileList      : SourceFileLists;

      ListingExtension    : EStrings.T;
      NoListings          : Boolean;

      Report              : Boolean;
      ReportFileName      : EStrings.T;

      WriteDict           : Boolean;
      DictFileName        : EStrings.T;

      FDLreserved         : Boolean;
      FDLmangle           : EStrings.T;

      HTML                : Boolean;
      HTMLDirectory       : EStrings.T;

      OutputDirectory     : Boolean;
      OutputDirectoryName : EStrings.T;

      RedType             : RedTypes;
      AnnoChar            : Character;

      AnalysisProfile     : AnalysisProfiles;
      InfoFlowPolicy      : InfoFlowPolicies;
      ConstantRules       : RuleGenerationPolicies;
      ErrorExplanation    : ErrorExplanations;
      JustificationOption : JustificationOptions;
      Debug               : DebugState;

      Echo                : Boolean;
      SyntaxOnly          : Boolean;
      WriteStatistics     : Boolean;
      DoInformationFlow   : Boolean;
      Spark95             : Boolean;
      DefaultSwitchFile   : Boolean;
      PlainOutput         : Boolean;
      VersionRequested    : Boolean;
      HelpRequested       : Boolean;
      VCfingerprints      : Boolean;
      NoDuration          : Boolean;
      Brief               : Boolean;
      XML                 : Boolean;
      LegacyErrors        : Boolean;
   end record;


   Content : CommandLineContents;

   procedure Initialize;
   --# global out Content;
   --# derives Content from ;

   -- Echoes the various filenames in Content to the terminal,
   -- iff Content.Debug.FileNames has been selected.
   procedure Dump_File_Names;
   --# global in Content;
   --# derives null from Content;

   function IsSpark95 return Boolean;
   --# global in Content;

   function IsSpark83 return Boolean;
   --# global in Content;

   function RavenscarSelected return Boolean;
   --# global in Content;

   -- If Content.OutputDirectory is set, then interpret and return F relative
   -- to the specified output directory
   procedure Normalize_FileName_To_Output_Directory (F : in out EStrings.T);
   --# global in Content;
   --# derives F from *,
   --#                Content;

end CommandLineData;
