-- $Id: commandlinedata.adb 12952 2009-04-09 13:13:58Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

---------------------------------------------------------------------------------------
-- WARNING: if you add or modify a command line switch be sure to update      --
--          PrintHelp in spark.apb                                            --
--------------------------------------------------------------------------------

with FileSystem,
     SPARK_IO;

package body CommandLineData
is
   Ada_Extension : constant EStrings.T :=
      EStrings.T'
      (3,
       EStrings.Contents'('a', 'd', 'a', others => ' '));

   Lst_Extension : constant EStrings.T :=
      EStrings.T'
      (3,
       EStrings.Contents'('l', 's', 't', others => ' '));

   Default_Report_File : constant EStrings.T :=
      EStrings.T'
      (9,
       EStrings.Contents'('s', 'p', 'a', 'r', 'k', '.', 'r', 'e', 'p',
       others => ' '));

   Default_Dict_File : constant EStrings.T :=
      EStrings.T'
      (9,
       EStrings.Contents'('s', 'p', 'a', 'r', 'k', '.', 'd', 'i', 'c', others => ' '));

   Default_HTML_Directory : constant EStrings.T :=
      EStrings.T'
      (4,
       EStrings.Contents'('H', 'T', 'M', 'L', others => ' '));

   procedure Initialize is
   begin
      Content := CommandLineContents'
         (Valid => True,
          Index => False,
          Warning => False,
          TargetData => False,
          TargetConfig => False,
          SourceExtension  => Ada_Extension,
          ListingExtension => Lst_Extension,
          NumberSource  => 0,
          Echo => True,
          Report => True,
          WriteDict => False,
          ReportFileName => Default_Report_File,
          DictFileName   => Default_Dict_File,
          RedType => NoVCG,
          WriteStatistics => False,
          DoInformationFlow => True,
          Spark95 => False,
          DefaultSwitchFile => False,
          HTML => False,
          HTMLDirectory => Default_HTML_Directory,
          OutputDirectory => False,
          OutputDirectoryname => EStrings.EmptyString,
          IndexFileName => EStrings.EmptyString,
          WarningFileName => EStrings.EmptyString,
          TargetDataFile => EStrings.EmptyString,
          TargetConfigFile => EStrings.EmptyString,
          SourceFileList =>
             SourceFileLists'(others => SourceFileEntry'
                              (SourceFileName => EStrings.EmptyString,
                               Listing => False,
                               ListingFileName => EStrings.EmptyString)),
          AnnoChar => '#',
          SyntaxOnly => False,
          FDLreserved => False,
          FDLmangle => EStrings.EmptyString,
          PlainOutput => False,
          VersionRequested    => False,
          HelpRequested       => False,
          VCfingerprints      => False,
          AnalysisProfile     => Sequential,
          NoDuration          => False,
          Brief               => False,
          XML                 => False,
          InfoFlowPolicy      => None,
          ConstantRules       => NoRules,
          LegacyErrors        => False,
          ErrorExplanation    => Off,
          JustificationOption => Full,
          NoListings          => False,
          Debug               => DebugState'
                                    (Enabled     => False,
                                     Expressions => False,
                                     HTML        => False,
                                     LookupTrace => False,
                                     FileNames   => False,
                                     Units       => False,
                                     Invariants  => False,
                                     Components  => False,
                                     Rho         => False,
                                     Parser      => False,
                                     FDL_Ranking => False,
                                     VCG         => False,
                                     VCG_All     => False,
                                     DAG         => False));
   end Initialize;

   procedure Dump_File_Names
   is
      --# hide Dump_File_Names;
   begin
      if Content.Debug.FileNames then
         SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
         SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                            "------------Dump of CommandLineData.Content File Names------------", 0);
         if Content.Index then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Index file is:", 0);
            EStrings.PutLine (SPARK_IO.Standard_Output, Content.IndexFileName);
         else
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output, "No Index File", 0);
         end if;

         if Content.Warning then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Warning file is:", 0);
            EStrings.PutLine (SPARK_IO.Standard_Output, Content.WarningFileName);
         else
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output, "No Warning File", 0);
         end if;

         if Content.TargetData then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Target Data File is:", 0);
            EStrings.PutLine (SPARK_IO.Standard_Output, Content.TargetDataFile);
         else
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output, "No Target Data File", 0);
         end if;

         if Content.TargetConfig then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Target Config File is:", 0);
            EStrings.PutLine (SPARK_IO.Standard_Output, Content.TargetConfigFile);
         else
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output, "No Target Config File", 0);
         end if;

         SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Source extension is:", 0);
         EStrings.PutLine (SPARK_IO.Standard_Output, Content.SourceExtension);

         SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Listing extension is:", 0);
         EStrings.PutLine (SPARK_IO.Standard_Output, Content.ListingExtension);

         SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Report File Name is:", 0);
         EStrings.PutLine (SPARK_IO.Standard_Output, Content.ReportFileName);

         SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Dictionary File Name is:", 0);
         EStrings.PutLine (SPARK_IO.Standard_Output, Content.DictFileName);

         if Content.OutputDirectory then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Output Directory is:", 0);
            EStrings.PutLine (SPARK_IO.Standard_Output, Content.OutputDirectoryName);
         else
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output, "Output directory is CWD", 0);
         end if;

         SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Number of Source Files is:", 0);
         SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Integer'Image (Content.NumberSource), 0);

         for I in SourceFilePositions range 1 .. Content.NumberSource loop
            EStrings.PutString (SPARK_IO.Standard_Output,
                                       Content.SourceFileList (I).SourceFileName);

            if Content.NoListings then
               SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                                  ", All listing files suppressed", 0);
            elsif Content.SourceFileList (I).Listing then
               SPARK_IO.Put_String (SPARK_IO.Standard_Output, ", ", 0);
               EStrings.PutLine (SPARK_IO.Standard_Output,
                                        Content.SourceFileList (I).ListingFileName);
            else
               SPARK_IO.Put_Line (SPARK_IO.Standard_Output, ", No listing file", 0);
            end if;
         end loop;

         SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Examiner Lib Directory is: ", 0);

         if Content.PlainOutput then
            EStrings.PutLine (SPARK_IO.Standard_Output,
                                     EStrings.LowerCase (FileSystem.ExaminerLibDirectory));
         else
            EStrings.PutLine (SPARK_IO.Standard_Output, FileSystem.ExaminerLibDirectory);
         end if;

         SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                            "------------End of CommandLineData.Content File Names-------------", 0);
         SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      end if;

   end Dump_File_Names;

   function IsSpark95 return Boolean
   is
   begin
      return Content.Spark95;
   end IsSpark95;

   function IsSpark83 return Boolean
   is
   begin
      return not Content.Spark95;
   end IsSpark83;

   function RavenscarSelected return Boolean
   is
   begin
      return Content.AnalysisProfile = Ravenscar;
   end RavenscarSelected;

   procedure Normalize_FileName_To_Output_Directory (F : in out EStrings.T)
   is
      Original : EStrings.T;

      procedure Debug
      --# derives ;
      is
         --# hide Debug;
      begin
         if Content.Debug.FileNames then
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Normalizing ", 0);
            EStrings.PutString (SPARK_IO.Standard_Output, Original);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, " with respect to ", 0);
            EStrings.PutString (SPARK_IO.Standard_Output, Content.OutputDirectoryName);
            SPARK_IO.Put_String (SPARK_IO.Standard_Output, " results in ", 0);
            EStrings.PutLine (SPARK_IO.Standard_Output, F);
         end if;
      end Debug;

   begin
      Original := F;
      if Content.OutputDirectory then
         F := FileSystem.InterpretRelative
           (FileName             => Original,
            RelativeToDirectory  => Content.OutputDirectoryName);
         Debug;
      end if;
   end Normalize_FileName_To_Output_Directory;

end CommandLineData;
