-- $Id: clists.ads 12696 2009-03-12 13:14:05Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Praxis High Integrity Systems Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with        Cells;

--# inherit Cells,
--#         Statistics;

package Clists
is

   function FirstCell (Heap     : Cells.Heap_Record;
                       ListName : Cells.Cell) return Cells.Cell;

   function LastCell (Heap     : Cells.Heap_Record;
                      ListName : Cells.Cell) return Cells.Cell;

   function NextCell (Heap     : Cells.Heap_Record;
                      CellName : Cells.Cell) return Cells.Cell;

   function IsEmptyList (Heap     : Cells.Heap_Record;
                         ListName : Cells.Cell) return Boolean;

   procedure AppendCell (Heap     : in out Cells.Heap_Record;
                         CellName : in     Cells.Cell;
                         ListName : in     Cells.Cell);
   --# derives Heap from *,
   --#                   CellName,
   --#                   ListName;

   procedure InsertCell (Heap     : in out Cells.Heap_Record;
                         CellName : in     Cells.Cell;
                         ListName : in     Cells.Cell);
   --# derives Heap from *,
   --#                   CellName,
   --#                   ListName;

   procedure Concatenate (Heap   : in out Cells.Heap_Record;
                          List_1 : in     Cells.Cell;
                          List_2 : in     Cells.Cell);
   --# derives Heap from *,
   --#                   List_1,
   --#                   List_2;

   -- transfer cells from List_1 to List_2;
   procedure TransferCells (Heap   : in out Cells.Heap_Record;
                            List_1 : in     Cells.Cell;
                            List_2 : in     Cells.Cell);
   --# derives Heap from *,
   --#                   List_1,
   --#                   List_2;

   procedure CreateList (Heap     : in out Cells.Heap_Record;
                         ListName :    out Cells.Cell);
   --# global in out Statistics.TableUsage;
   --# derives Heap,
   --#         Statistics.TableUsage from *,
   --#                                    Heap &
   --#         ListName              from Heap;

   procedure DisposeOfList (Heap     : in out Cells.Heap_Record;
                            ListName : in     Cells.Cell);
   --# derives Heap from *,
   --#                   ListName;

   procedure RemoveLeader (Heap     : in out Cells.Heap_Record;
                           ListName : in     Cells.Cell);
   --# derives Heap from *,
   --#                   ListName;

end Clists;
