%  $Id: version.template.pro 12292 2009-01-26 11:59:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Describes version related information for all Sicstus systems.
%
% Note that, from the perspective of the Sicstus system, this file is static.
% For each build, the file version.pro is regenerated to contain current
% information.
%###############################################################################


%###############################################################################
%MODULE
%###############################################################################
:- module(version, [toolset_version/1,
                    toolset_copyright/1,
                    toolset_distribution/1,
                    toolset_support_line1/1,
                    toolset_support_line2/1,
                    toolset_support_line3/1,
                    toolset_support_line4/1,
                    toolset_build_date/1,
                    toolset_build_stamp/1]).

%###############################################################################
%DEPENDENCIES
%###############################################################################


%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% toolset_version(-Atom).
% toolset_copyright(-Atom).
% toolset_distribution(-Atom).
% toolset_support_line1(-Atom).
% toolset_support_line2(-Atom).
% toolset_support_line3(-Atom).
% toolset_support_line4(-Atom).
% toolset_build_date(-Int).
% toolset_build_stamp(-Atom).
%-------------------------------------------------------------------------------
% Various predicates to return system version related information.
%
% Note that the INS items are placeholders, and will be replaced with thier
% actual values during a build.
%===============================================================================

toolset_version('8.1.1').
toolset_copyright('Copyright (C) 2009 Praxis High Integrity Systems Ltd., Bath, U.K.').
toolset_distribution('GPL').
toolset_support_line1('').
toolset_support_line2('Report bugs to: report@adacore.com').
toolset_support_line3('').
toolset_support_line4('').
toolset_build_date(20090505).
toolset_build_stamp('13202').

%===============================================================================


%###############################################################################
% END-OF-FILE
