%  $Id: subgoal.pro 12104 2009-01-13 09:51:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


/*** QUIT -- quit current frame (if any) ***/
quit :-
    clear_up_could_facts,
    (
       case_pointer(0),
       !,
       write('NO FRAME LEFT TO QUIT')
    ;
       case_pointer(CP),
       CP>0,
       assertz(logfact(quitframe, CP)),
       (
          subgoal_formula(CP,_,_,METHOD),
          !,
          write('QUITTING CURRENT PROOF BY '),
          print(METHOD),
          write(' ATTEMPT'),
          nl,                                                   /* CFR007 */
          abort_subgoal
       ;
          on_case(CP,_,_),
          !,
          write('QUITTING CURRENT PROOF BY CASES ATTEMPT'),
          nl,                                                   /* CFR007 */
          abort_case
       )
    ), !.


/*** ABORT_SUBGOAL -- abort current attempt to prove by subgoaling ***/
abort_subgoal :-
        case_pointer(CP),
        subgoal_formula(CP,_,_,_),
        retractall(subgoal_formula(CP,_,_,_)),
        retractall(on_case(CP,_,_)),
        retractall(case(CP,_,_)),
        retractall(proved_for_case(CP,_)),
        C is CP-1,
        retractall(case_pointer(_)),
        asserta(case_pointer(C)),
        case_restore(CP),
        !.


/*** START_SUBGOAL(FORMULA,CONDS,HYPS,METHOD) -- set up for subgoaling ***/
start_subgoal(FORMULA,CONDITIONS,HYPOTHESES,METHOD) :-
        (                                                       /* CFR009 */
           checktype(FORMULA, boolean),                         /* CFR009 */
           checkhastypelist(CONDITIONS, boolean),               /* CFR009 */
           checktype(HYPOTHESES, boolean)                       /* CFR009 */
        ;                                                       /* CFR009 */
           write('!!! Error: type-check failed on subgoal proof-frame entry attempt'),
           nl,                                                  /* CFR009 */
           !,                                                   /* CFR009 */
           fail                                                 /* CFR009 */
        ),                                                      /* CFR009 */
        !,                                                      /* CFR009 */
        clear_up_could_facts,
        case_pointer(CP),
        retractall(case_pointer(_)),
        C is CP+1,
        assertz(case_pointer(C)),
        retractall(proved_for_case(C,_)),
        retractall(case(C,_,_)),
        retractall(on_case(C,_,_)),
        assertz(logfact(method, METHOD)),
        assertz(logfact(enterframe, C)),
        case_save(C),
        (
           conc(NUM,FORMULA)
        ;
           NUM=[]
        ),
        retractall(conc(_,_)),
        assertz(logfact(text, 'All current conclusions withdrawn')),
        assertz(subgoal_formula(C,FORMULA,NUM,METHOD)),
        create_formula(CONDITIONS,HYPOTHESES,CONCS -> HYPS),
        format_formula(logmessage, HYPS -> CONCS),                  /* CFR054 */
        !.

%Make command calls visible to the spxref tool.
:- public contradict/1.
:- public implication/1.
:- public induction/0.
:- public cases/0.

/*** PROVE -- prove FORMULA by STRATEGY [ on DISJUNCTION ] ***/
prove :-
        clear_up_could_facts,
        command_arg(expression, EXPRN),
        command_arg(strategy, STRATEGY),
        (
           STRATEGY='contradiction',
           CALL=contradict(EXPRN)
        ;
           STRATEGY='implication',
           CALL=implication(EXPRN)
        ;
           STRATEGY='induction',
           CALL=induction
        ;
           STRATEGY='cases',
           CALL=cases
        ),
        !,
        call(CALL),
        !.
%###############################################################################
%END-OF-FILE
