%  $Id: initvals.pro 12229 2009-01-20 16:30:14Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


/*** DISPLAY_SUBGOALS_MAX(N) - maximum number of subgoals for rule display ***/
:- dynamic(display_subgoals_max/1).
display_subgoals_max(10).


/*** DISPLAY_VAR_FREE_ONLY(FLAG) - on <-> only display if subgoals var-free ***/
:- dynamic(display_var_free_only/1).
display_var_free_only(off).


/*** CASE_POINTER(N) - proof-by-cases depth counter: initially zero ***/
:- dynamic(case_pointer/1).
case_pointer(0).        /*** ADDED 8/3/85 ***/


/*** INPUT_FROM_TERMINAL - true if standard input is sys$input ***/
:- dynamic(input_from_terminal/0).
input_from_terminal.  /* retracted by command in file if not */

% The 'input_from_terminal' predicate is not used in the Checker code.
% However, there is a suggestion that it might be retracted in a command
% file. The behaviour of the retract will be different, depending on
% whether or not the predicate is added here. Thus to preserve this
% potential legacy behaviour, the code is not removed. The potential
% retract is considered to be a potential call, and is thus made visible to
% the spxref tool.
:- public input_from_terminal/0.


/*** VC_STANDARDISATION(FLAG) - automatic standardisation status (on/off) ***/
:- dynamic(vc_standardisation/1).
vc_standardisation(off).


/*** ECHO(FLAG) - echoing of file input (on/off) ***/
:- dynamic(echo/1).
echo(on).


/*** AUTO_DONE(FLAG) - automatic multi-level exit of "done" (on/off) ***/
:- dynamic(auto_done/1).
auto_done(on).


/*** SIMPLIFY_IN_INFER(FLAG) - whether "infer" may use simplifier (on/off) ***/
:- dynamic(simplify_in_infer/1).
simplify_in_infer(on).                  /***MODIFIED***/


/*** SIMPLIFY_DURING_LOAD(FLAG) - whether "loadvc" may simplify (on/off) ***/
:- dynamic(simplify_during_load/1).
simplify_during_load(on).               /***MODIFIED***/


/*** STANDARDISE_IN_INFER(FLAG) - can "infer" use standardiser? (on/off) ***/
:- dynamic(standardise_in_infer/1).
standardise_in_infer(off).


/*** step_number(N) - step number ***/
:- dynamic(step_number/1).
step_number(0).


/*** Indentation for proof log - should initially be 0 ***/
:- dynamic(indentation/1).
indentation(0).


/*** Proof frames indentation increment for proof log ***/
:- dynamic(indentation_increment/1).
indentation_increment(2).


/*** Typechecking(FLAG) -- should normally be ON ***/
:- dynamic(typechecking/1).
typechecking(on).


/*** Prooflog_width(WIDTH) -- maximum columns for proof log ***/
:- dynamic(prooflog_width/1).
prooflog_width(0).


/*** record_consults(FLAG) -- whether to record rule-file consultations in
        proof log ***/
:- dynamic(record_consults/1).
record_consults(on).


/*** inverse_video(X)/normal_video(X) -- for highlighting on screen ***/
:- dynamic(inverse_video/1).
inverse_video([]).
:- dynamic(normal_video/1).
normal_video([]).


/*** typechecking_during_load(FLAG) -- prevent typechecking if VCGenerated ***/
:- dynamic(typechecking_during_load/1).
typechecking_during_load(on).


/*** use_subst_rules_for_equality(FLAG) -- allow infer to use rewrite rules ***/
:- dynamic(use_subst_rules_for_equality/1).
use_subst_rules_for_equality(on).


/*** command_logging(FLAG) -- whether or not to log user's commands/replies ***/
:- dynamic(command_logging/1).
command_logging(on).                                            /* CFR015 */


/*** show_vc_changes(FLAG) -- whether or not to show new/changed hyps/concs ***/
:- dynamic(show_vc_changes/1).
show_vc_changes(on).


/*** auto_newvc(FLAG) -- whether or not to do a newvc automatically ***/
:- dynamic(auto_newvc/1).
auto_newvc(on).                                                 /* CFR025 */

/* newline_after_prompts(FLAG) -- whether or not to do a <CR> after each prompt ***/
:- dynamic(newline_after_prompts/1).
newline_after_prompts(off).                                     /* CFR1334 */

/*** plain_output(FLAG) -- plain output mode on or off.  Default off ***/
:- dynamic(plain_output/1).
plain_output(off).

/*** overwrite_warning(FLAG) -- on or off.  Default off ***/
:- dynamic(overwrite_warning/1).
overwrite_warning(off).
%###############################################################################
%END-OF-FILE
