%  $Id: initialise.pro 12104 2009-01-13 09:51:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


read_initialisations :-
        spade_checker_prefix(SPADE_CHECKER),                    /* CFR048 */
        append(SPADE_CHECKER, "checker.ini", INILIST),          /* CFR048 */
        name(INIFILE, INILIST),                                 /* CFR048 */
        read_init_file(INIFILE).                                /* CFR048 */
read_initialisations :-
        read_init_file('checker.ini').                          /* CFR048 */
read_initialisations.


read_init_file(FILE) :-
        file_exists_and_is_readable(FILE),
        !,
        repeat,
            see(FILE),
            read_term_and_layout(DECLARATION),
            process_initialisation(DECLARATION),
        /* UNTIL */ DECLARATION == end_of_file,
        seen,
        !,
        fail.
/* Don't fail as it looks for two files - one in rules dir, one in current dir */
/* It will use both if it finds both */
read_init_file(FILE) :-
        \+ file_exists_and_is_readable(FILE),
        fail.

process_initialisation(DECLARATION) :-
        var(DECLARATION),
        !,
        write('!!! PROLOG VAR IN INITIALISATION FILE'),
        nl,
        !.
process_initialisation(end_of_file) :- !.
process_initialisation(DECLARATION) :-
        \+ novars(DECLARATION),
        !,
        write('!!! PROLOG VAR IN INITIALISATION FILE'),
        nl,
        !.
process_initialisation(set memory_limit to VALUE) :-
        integer(VALUE),
        !,
        (
           VALUE >= 250000,
           set_memory_limit(VALUE)
        ;
           write('WARNING: Memory limit value too small'),
           !,
           fail
        ), !.
process_initialisation(set FLAG to VALUE) :-
        is_a_flag(FLAG, VALUETYPE),
        ok_value(VALUE, VALUETYPE),
        OLD =.. [FLAG, _],
        NEW =.. [FLAG, VALUE],
        !,
        retractall(OLD),
        asserta(NEW),
        !.
process_initialisation(set FLAG to VALUE) :-
        is_a_flag(FLAG, _VALUETYPE),
        !,
        write('!!! INITIALISATION: '),
        print(VALUE),
        write(' is not of appropriate type for '),
        print(FLAG),
        nl,
        !.
process_initialisation(set FLAG to _VALUE) :-
        !,
        write('!!! INITIALISATION: '),
        print(FLAG),
        write(' is not a user-configurable flag.'),
        nl,
        !.
process_initialisation(consult FILE) :-
        atom(FILE),
        !,
        maybe_add(ini_file_consult(FILE)),                      /* CFR021 */
        !.

is_a_flag(display_subgoals_max, integer/0/99).
is_a_flag(display_var_free_only, boolean).
is_a_flag(echo, boolean).
is_a_flag(auto_done, boolean).
is_a_flag(simplify_in_infer, boolean).
is_a_flag(simplify_during_load, boolean).
is_a_flag(typechecking, boolean).
is_a_flag(typechecking_during_load, boolean).
is_a_flag(prooflog_width, integer/80/255).
is_a_flag(record_consults, boolean).
is_a_flag(inverse_video, int_list/integer).
is_a_flag(normal_video, int_list/integer).
is_a_flag(use_subst_rules_for_equality, boolean).
is_a_flag(command_logging, boolean).                            /* CFR032 */
is_a_flag(show_vc_changes, boolean).                            /* CFR032 */
is_a_flag(auto_newvc, boolean).                                 /* CFR032 */
is_a_flag(newline_after_prompts, boolean).                      /* CFR1334 */
is_a_flag(indentation_increment, integer/0/EOL) :- eol_char(EOL).

ok_value(on,    boolean).
ok_value(off,   boolean).
ok_value(0,     integer/_A/_B).
ok_value(NUM,   integer/A/B) :- integer(NUM), NUM>=A, NUM =< B.
ok_value([H|T], int_list/X) :-
        integer(H), 0 < H, H < 128, !, ok_value(T, int_list/X).
ok_value([],    int_list/_X).
%###############################################################################
%END-OF-FILE
