%  $Id: induction.pro 12104 2009-01-13 09:51:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


induction(F,VAR,BASE) :-
        (
           F=c#N,
           integer(N),
           conc(N,FORMULA)
        ;
           checktype(F,boolean),
           FORMULA=F
        ),
        subst_vbl(VAR,BASE,FORMULA,BASECASE),
        (
           atom(VAR),
           make_new_var(uvar,VAR,integer,INDVAR)
        ;
           make_new_var(uvar,ind,integer,INDVAR)
        ),
        make_new_var(uvar,z,integer,QUANTVAR),
        !,
        subst_vbl(VAR,QUANTVAR,FORMULA,ASSUME),
        subst_vbl(VAR,INDVAR+1,FORMULA,PROVE),
        write('ENTERING PROOF BY INDUCTION ATTEMPT'),
        INDCASE=(INDVAR>=BASE ->
                  (for_all(QUANTVAR:integer,
                    (BASE<=QUANTVAR and QUANTVAR<=INDVAR) ->
                      ASSUME) -> PROVE)),
        nl,
        assertz(logfact(induction, [FORMULA, VAR, BASE])),
        start_subgoal(FORMULA,[BASECASE,INDCASE],true,'INDUCTION'),
        !.

induction :-
        prompt_user('INDUCTION -- on what? '),
        rread(INDVAR),
        prompt_user('INDUCTION -- Base case? '),
        rread(BASECASE),
        novars(INDVAR>=BASECASE),
        infer(INDVAR>=BASECASE),
        command_arg(expression, FORMULA),
        induction(FORMULA, INDVAR, BASECASE).
%###############################################################################
%END-OF-FILE
