%  $Id: contra.pro 12104 2009-01-13 09:51:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


/*** CONTRADICT(FORMULA_OR_CONC_NUM) -- proof by contradiction ***/
contradict(F) :-
        (
           F=c#N,
           integer(N),
           conc(N,FORMULA)
        ;
           checktype(F,boolean),
           FORMULA=F
        ),
        write('ENTERING PROOF BY CONTRADICTION ATTEMPT'),
        nl,
        start_subgoal(FORMULA,[false],(not FORMULA),'CONTRADICTION'),
        !.


/*** IMPLICATION(FORMULA_OR_CONC_NUM) -- proof by implication ***/
implication(F) :-
        (
           F=c#N,
           integer(N),
           conc(N,FORMULA)
        ;
           checktype(F,boolean),
           FORMULA=F
        ),
        FORMULA=(ASSUMPTIONS -> GOAL),
        create_formula(GOALS,false,GOAL -> false),
        write('ENTERING PROOF BY IMPLICATION ATTEMPT'),
        nl,
        start_subgoal(FORMULA,GOALS,ASSUMPTIONS,'IMPLICATION'),
        !.
%###############################################################################
%END-OF-FILE
