%  $Id: checker.pro 12108 2009-01-13 10:23:36Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Praxis High Integrity Systems Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Top level file, to build the Checker without flexlm.
%###############################################################################

%###############################################################################
% DEPENDENCIES
%###############################################################################


%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% DYNAMIC FEATURES PRE-LOAD
%===============================================================================

% Establish sicstus settings.
:- set_prolog_flag(unknown, error).
portray_message(informational, _).

% Establish all dynamic predicates.
:- include('dynamics.pro').
%===============================================================================


%===============================================================================
%FIXED SYSTEM CONFIGURATION
%-------------------------------------------------------------------------------
%This information will be the same for every execution of the tool.
%===============================================================================
:-use_module('../simplifier/datasystem.pro',
             [add_system_toolname/1]).

:-add_system_toolname('Proof Checker').
%===============================================================================


%===============================================================================
% LOAD SYSTEM
%===============================================================================
:- include('loadsicstus.pro').
%===============================================================================


%===============================================================================
% runtime_entry(start).
%-------------------------------------------------------------------------------
% This is a special Sicstus predicate, which will be automatically invoked
% when restoring a saved state. It is the top level, or main, predicate.
%===============================================================================

runtime_entry(start):-
    startup_sequence,
    halt(0),
    !.
%===============================================================================


%===============================================================================
% SAVE SYSTEM AND HALT
%===============================================================================
:- save_program('checker.sav').
:- halt.
%===============================================================================


%###############################################################################
%END-OF-FILE
