-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Package to perform processing of VC files                                   --
--                                                                            --
--------------------------------------------------------------------------------

with E_Strings;
with SPARK_IO;

use type SPARK_IO.File_Status;

--# inherit Ada.Characters.Handling,
--#         Banner,
--#         CommandLine,
--#         Date_Time,
--#         E_Strings,
--#         FatalErrors,
--#         Heap,
--#         OSFiling,
--#         PathFormatter,
--#         SLG_Parser,
--#         SPARK_Calendar,
--#         SPARK_IO,
--#         Total,
--#         VCDetails,
--#         VCHeap;

package VCS is

   -- given the filename, without extension, process vcg, siv, plg and prv files
   -- if/as appropriate
   procedure Analyse
     (Report_File             : in     SPARK_IO.File_Type;
      Filename                : in     E_Strings.T;
      Analyse_Proof_Log       : in     Boolean;
      Temp_File               : in     SPARK_IO.File_Type;
      Temp_False_File         : in     SPARK_IO.File_Type;
      Temp_Contra_File        : in     SPARK_IO.File_Type;
      Temp_Victor_File        : in     SPARK_IO.File_Type;
      Temp_Riposte_File       : in     SPARK_IO.File_Type;
      Temp_User_File          : in     SPARK_IO.File_Type;
      Temp_Rlu_Error_File     : in out SPARK_IO.File_Type;
      Temp_Rlu_Used_File      : in out SPARK_IO.File_Type;
      Temp_PR_Verr_File       : in     SPARK_IO.File_Type;
      Temp_Warn_Error_File    : in     SPARK_IO.File_Type;
      Temp_SDP_Error_File     : in     SPARK_IO.File_Type;
      Temp_DPC_Error_File     : in     SPARK_IO.File_Type;
      Temp_Victor_Error_File  : in     SPARK_IO.File_Type;
      Temp_Riposte_Error_File : in     SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in     OSFiling.File_Structure;
   --#        in out FatalErrors.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out Total.State;
   --#        in out VCHeap.I_State;
   --#        in out VCHeap.State;
   --# derives FatalErrors.State,
   --#         VCHeap.I_State      from *,
   --#                                  Analyse_Proof_Log,
   --#                                  CommandLine.Data,
   --#                                  Filename,
   --#                                  OSFiling.File_Structure,
   --#                                  Report_File,
   --#                                  SPARK_IO.File_Sys,
   --#                                  Temp_Rlu_Error_File,
   --#                                  Temp_Rlu_Used_File,
   --#                                  VCHeap.I_State,
   --#                                  VCHeap.State &
   --#         SPARK_IO.File_Sys   from *,
   --#                                  Analyse_Proof_Log,
   --#                                  CommandLine.Data,
   --#                                  Filename,
   --#                                  OSFiling.File_Structure,
   --#                                  Report_File,
   --#                                  Temp_Contra_File,
   --#                                  Temp_DPC_Error_File,
   --#                                  Temp_False_File,
   --#                                  Temp_File,
   --#                                  Temp_PR_Verr_File,
   --#                                  Temp_Riposte_Error_File,
   --#                                  Temp_Riposte_File,
   --#                                  Temp_Rlu_Error_File,
   --#                                  Temp_Rlu_Used_File,
   --#                                  Temp_SDP_Error_File,
   --#                                  Temp_User_File,
   --#                                  Temp_Victor_Error_File,
   --#                                  Temp_Victor_File,
   --#                                  Temp_Warn_Error_File,
   --#                                  VCHeap.I_State,
   --#                                  VCHeap.State &
   --#         Temp_Rlu_Error_File,
   --#         Temp_Rlu_Used_File  from *,
   --#                                  Filename,
   --#                                  OSFiling.File_Structure,
   --#                                  SPARK_IO.File_Sys &
   --#         Total.State,
   --#         VCHeap.State        from *,
   --#                                  Analyse_Proof_Log,
   --#                                  CommandLine.Data,
   --#                                  Filename,
   --#                                  OSFiling.File_Structure,
   --#                                  Report_File,
   --#                                  SPARK_IO.File_Sys,
   --#                                  VCHeap.I_State,
   --#                                  VCHeap.State;

end VCS;
