-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function CompatibleTypes
  (Scope : Scopes;
   Left  : Symbol;
   Right : Symbol)
  return  Boolean
is
   Base1  : Symbol;
   Base2  : Symbol;
   Result : Boolean;

   --------------------------------------------------------------------------------

   function IsRealType (TheSymbol : Symbol;
                        Scope     : Scopes) return Boolean
   --# global in Dict;
   is
   begin
      return IsType (TheSymbol) and then TypeIsReal (TheSymbol) and then not TypeIsPrivateHere (TheSymbol, Scope);
   end IsRealType;

   --------------------------------------------------------------------------------

begin

   if TypeIsUnknown (Left) or else TypeIsUnknown (Right) then
      Result := True;
   else
      Base1 := GetRootType (Left);
      Base2 := GetRootType (Right);

      if Base1 = Base2 then
         Result := True;

      elsif IsUniversalIntegerType (Base1) then
         Result := IsIntegerType (Base2, Scope) or IsModularType (Base2, Scope);

      elsif IsUniversalIntegerType (Base2) then
         Result := IsIntegerType (Base1, Scope) or IsModularType (Base1, Scope);

      elsif IsUniversalRealType (Base1) then
         Result := IsRealType (Base2, Scope);

      elsif IsUniversalRealType (Base2) then
         Result := IsRealType (Base1, Scope);

      else
         Result := False;
      end if;

   end if;

   return Result;

end CompatibleTypes;
