-- $Id: units.ads 11375 2008-10-08 10:40:42Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Unit;

--# inherit Unit;

package Units
is

   type Stack is private;
   NullStack : constant Stack;

   type Iterator is private;

   ----------------------------------------------------------
   -- Id Stack
   ----------------------------------------------------------

   function InStack (TheUnit  : in Unit.Id;
                     TheStack : in Stack) return Boolean;

   procedure Push (TheStack : in out Stack;
                   TheUnit  : in     Unit.Id);
   --# derives TheStack from *,
   --#                       TheUnit;

   procedure Pop (TheStack : in out Stack;
                  TheUnit  :    out Unit.Id);
   --# derives TheStack,
   --#         TheUnit  from TheStack;

   function IsEmpty (TheStack : Stack) return Boolean;


   procedure Sort (TheUnits : in out Stack);
   --# derives TheUnits from *;

   procedure Init_Iterator (TheStack : in Stack; TheIterator : out Iterator);
   --# derives TheIterator from TheStack;

   function  Iterated (TheIterator : in Iterator) return Boolean;

   procedure Iterate (TheIterator : in out Iterator;
                      TheUnit     :    out Unit.Id);
   --# derives TheIterator,
   --#         TheUnit     from TheIterator;


private

   --# hide Units;

   type Node;

   type Stack is access Node;
   NullStack : constant Stack := null;

   type Node is
      record
         TheItem : Unit.Id;
         Next    : Stack;
      end record;

   type Iterator is new Stack;

end Units;
