-- $Id: unitmanager.ads 15526 2010-01-07 13:41:57Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;
with StringList;
with Unit;
with Units;

use type Unit.Object;
use type Unit.Id;
use type Unit.Kind;

--# inherit CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         LexTokenManager,
--#         Directory_Operations,
--#         RegularExpression,
--#         SparkLex,
--#         SparkMakeErrors,
--#         SPARK_IO,
--#         StringList,
--#         Unit,
--#         Units;

package UnitManager
--# own State;
--# initializes State;
is


   procedure Initialise (TheDirectories : in     StringList.Object;
                         Include        : in     StringList.Object;
                         Exclude        : in     StringList.Object;
                         RootFile       : in     EStrings.T;
                         Duplicates     : in     Boolean;
                         Success        :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --#           out SparkLex.CurrLine;
   --# derives ErrorHandler.ErrorContext,
   --#         LexTokenManager.State,
   --#         SparkLex.CurrLine,
   --#         SPARK_IO.File_Sys,
   --#         State,
   --#         Success                   from CommandLineData.Content,
   --#                                        Dictionary.Dict,
   --#                                        Duplicates,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Exclude,
   --#                                        Include,
   --#                                        LexTokenManager.State,
   --#                                        RootFile,
   --#                                        SPARK_IO.File_Sys,
   --#                                        State,
   --#                                        TheDirectories;

   -------------------------------------------------------------

   function GetAllUnits return Units.Stack;
   --# global in State;


   procedure GetUnit (InFile  : in     EStrings.T;
                      TheUnit :    out Unit.Id;
                      Found   :    out Boolean);
   --# global in State;
   --# derives Found,
   --#         TheUnit from InFile,
   --#                      State;


   procedure GetFile (ForUnit : in     Unit.Id;
                      TheFile :    out EStrings.T;
                      Found   :    out Boolean);
   --# global in State;
   --# derives Found,
   --#         TheFile from ForUnit,
   --#                      State;


   function Get (TheUnit : Unit.Id) return Unit.Object;
   --# global in State;


   function PackageBody (ForUnit : Unit.Id) return Unit.Id;
   --# global in State;


   function Parent (OfUnit : Unit.Id) return Unit.Id;
   --# global in State;


   function SeparateUnits (ForUnit : Unit.Id) return Units.Stack;
   --# global in State;


   function RequiredUnits (ForUnit : Unit.Id) return Units.Stack;
   --# global in State;


   function Components (ForUnit : Unit.Id) return Units.Stack;
   --# global in State;

   -- Search all units in UnitManager and return a stack of root
   -- units, ie units that are not required by other units.
   function FindRoots return Units.Stack;
   --# global in State;


end UnitManager;
