-- $Id: unitmanager-unitstore.ads 11375 2008-10-08 10:40:42Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Unit;
with Units;

--# inherit EStrings,
--#         Unit,
--#         UnitManager,
--#         Units;

private package UnitManager.UnitStore
--# own State;
--# initializes State;
is


   procedure Add (TheUnit : in     Unit.Object;
                  Added   :    out Boolean);
   --# global in out State;
   --# derives Added,
   --#         State from State,
   --#                    TheUnit;


   function Get (TheUnit : Unit.Id) return Unit.Object;
   --# global in State;


   function GetBodyUnit (WithName : in EStrings.T) return Unit.Object;
   --# global in State;


   function GetSpecificationUnit (WithName : in EStrings.T) return Unit.Object;
   --# global in State;


   function GetAllUnits return Units.Stack;
   --# global in State;


end UnitManager.UnitStore;
