-- $Id: tokenmanager.adb 15526 2010-01-07 13:41:57Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with LexTokenManager;
with SparkLex;
with SPSymbols;
with SparkMakeErrors;

use type SPSymbols.SPTerminal;

package body TokenManager
is

   procedure Next (It : in out Iterator)
   is
      Unused           : Boolean;
      TokenKind        : SPSymbols.SPTerminal;
      LexValue         : LexTokenManager.Lex_Value;

      procedure GetIdentifier (It : in out Iterator)
      --# global in     CommandLineData.Content;
      --#        in     Dictionary.Dict;
      --#        in out ErrorHandler.ErrorContext;
      --#        in out LexTokenManager.State;
      --#        in out SparkLex.CurrLine;
      --#        in out SPARK_IO.File_Sys;
      --# derives ErrorHandler.ErrorContext,
      --#         It,
      --#         LexTokenManager.State,
      --#         SparkLex.CurrLine,
      --#         SPARK_IO.File_Sys         from CommandLineData.Content,
      --#                                        Dictionary.Dict,
      --#                                        ErrorHandler.ErrorContext,
      --#                                        It,
      --#                                        LexTokenManager.State,
      --#                                        SparkLex.CurrLine,
      --#                                        SPARK_IO.File_Sys;
      is
         Unused        : Boolean;
         TokenKind     : SPSymbols.SPTerminal;
         LexValue      : LexTokenManager.Lex_Value;
      begin
         while It /= NullIterator loop
            -- is there more dotted notation?
            --# accept Flow, 10, Unused, "Ineffective assignment OK";
            SparkLex.ExaminerLex (ProgText   => It.File,
                                  Token      => TokenKind,
                                  LexVal     => LexValue,
                                  PunctToken => Unused);
            --# end accept;

            -- No, this is the end of the identifier and we have read a token too far.
            if TokenKind /= SPSymbols.point then
               It.NextToken := Token'(Kind  => TokenKind,
                                      Value => LexTokenManager.Lex_String_To_String (Lex_Str => LexValue.Token_Str));
               exit;
            end if;

            -- Read the next part of the dotted identifier
            --# accept Flow, 10, Unused, "Ineffective assignment OK";
            SparkLex.ExaminerLex (ProgText   => It.File,
                                  Token      => TokenKind,
                                  LexVal     => LexValue,
                                  PunctToken => Unused);
            --# end accept;

            if TokenKind /= SPSymbols.identifier then
               -- Invlaid syntax return a null iterator
               It := NullIterator;
            else
               EStrings.Append_String (E_Str => It.CurrentToken.Value,
                                       Str   => ".");
               EStrings.Append_Examiner_String
                 (E_Str1 => It.CurrentToken.Value,
                  E_Str2 => LexTokenManager.Lex_String_To_String (Lex_Str => LexValue.Token_Str));
            end if;
         end loop;
         --# accept Flow, 33, Unused, "Unused not references OK";
      end GetIdentifier;

   begin
      if It = NullIterator then
         SparkMakeErrors.Fatal ("calling TokenManager.Next with a null iterator.");

      elsif It.IsLookAhead then
         It.IsLookAhead := False;

      elsif It.NextToken /= NullToken then
         It.CurrentToken := It.NextToken;
         It.NextToken := NullToken;

      else
         --# accept Flow, 10, Unused, "Ineffective assignment OK";
         SparkLex.ExaminerLex (ProgText   => It.File,
                               Token      => TokenKind,
                               LexVal     => LexValue,
                               PunctToken => Unused);
         --# end accept;

         if TokenKind = SPSymbols.SPEND then
            It := NullIterator;
         else
            It.CurrentToken := Token'(Kind  => TokenKind,
                                      Value => LexTokenManager.Lex_String_To_String (Lex_Str => LexValue.Token_Str));
            if TokenKind = SPSymbols.identifier then
               GetIdentifier (It => It);
            end if;
         end if;
      end if;
      --# accept Flow, 33, Unused, "Unused not references OK";
   end Next;

   -----------------------------------------------------------------------------

   procedure LookAhead (It : in out Iterator)
   is
   begin
      if It = NullIterator then
         SparkMakeErrors.Fatal ("calling TokenManager.LookAhead with a null iterator.");
      elsif not It.IsLookAhead then
         Next (It => It);
         It.IsLookAhead := True;
      end if;
   end LookAhead;

   -----------------------------------------------------------------------------

   procedure GetFirstToken (FileId : in     SPARK_IO.File_Type;
                            It     :    out Iterator)
   is
      NewIt : Iterator;
   begin
      SparkLex.ClearLineContext;
      NewIt := Iterator'(File => FileId,
                         CurrentToken => NullToken,
                         NextToken    => NullToken,
                         IsLookAhead => False);
      Next (It => NewIt);
      It := NewIt;
   end GetFirstToken;

   -----------------------------------------------------------------------------

   function IsNull (It : Iterator) return Boolean
   is
   begin
      return It = NullIterator;
   end IsNull;

   -----------------------------------------------------------------------------

   function Current (It : Iterator) return Token
   is
      Result : Token;
   begin
      if It = NullIterator then
         Result := NullToken;
      else
         Result := It.CurrentToken;
      end if;
      return Result;
   end Current;

   -----------------------------------------------------------------------------

   function ToString (Tok : Token) return EStrings.T
   is
      --# hide ToString;
      Result : EStrings.T := EStrings.Empty_String;
   begin
      EStrings.Append_String
        (E_Str => Result,
         Str   => SPSymbols.SPTerminal'Image (Tok.Kind) & ": ");
      EStrings.Append_Examiner_String
        (E_Str1 => Result,
         E_Str2 => Tok.Value);
      return Result;
   end ToString;

end TokenManager;
