-- $Id: stringlist.ads 13044 2009-04-20 08:40:02Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;

--# inherit EStrings,
--#         SPARK_IO;

package StringList
is

   type Object is private;
   NullObject : constant Object;

   type Iterator is private;


   ------------------------------------------------------------------------
   -- Constructors
   ------------------------------------------------------------------------

   procedure AddToFront (ToList  : in out Object;
                         TheItem : in     EStrings.T);
   --# derives ToList from *,
   --#                     TheItem;
   --
   -- Adds the TheItem to the front of ToList.
   -- No change if TheItem is already present.

   procedure AddToBack (ToList  : in out Object;
                        TheItem : in     EStrings.T);
   --# derives ToList from *,
   --#                     TheItem;
   --
   -- Adds the TheItem to the back of ToList.

   -- Assuming ToList is already sorted, then adds TheItem
   -- to the list so it remains sorted.  Here, "sorted" is
   -- defined by the "<=" operator for Standard.String
   procedure AddInLexOrder (ToList  : in out Object;
                            TheItem : in     EStrings.T);
   --# derives ToList from *,
   --#                     TheItem;

   function GetFirst (InList : Object) return Iterator;
   --
   -- Returns an iterator for the first item in the list


   function Next (It : Iterator) return Iterator;
   --
   -- Returns the next iterator.


   ------------------------------------------------------------------------
   -- Accessors
   ------------------------------------------------------------------------

   function IsNull (It : Iterator) return Boolean;

   function Value (It : Iterator) return EStrings.T;


   ------------------------------------------------------------------------
   -- Debug support
   ------------------------------------------------------------------------

   type Orientation is (Vertical, Horizontal);

   procedure Output (TheList : in Object;
                     How     : in Orientation);
   --# global in out SPARK_IO.FILE_SYS;
   --# derives SPARK_IO.FILE_SYS from *,
   --#                                How,
   --#                                TheList;


private

   --# hide StringList;

   type Node;

   type Object is access Node;
   NullObject : constant Object := null;

   type Node is
      record
         TheItem : EStrings.T;
         Next    : Object;
      end record;

   type Iterator is new Object;

   NullIterator : constant Iterator := Iterator (NullObject);

end StringList;
