-- $Id: sparkmakedebug.ads 11375 2008-10-08 10:40:42Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;
with StringList;

--# inherit EStrings,
--#         StringList;

package SparkMakeDebug
is

   procedure ReportText (Text  : in String);
   --# derives null from Text;


   procedure ReportTextEText (Text  : in String;
                              EText : in EStrings.T);
   --# derives null from EText,
   --#                   Text;


   procedure ReportList (Text : in String;
                         List : in StringList.Object);
   --# derives null from List,
   --#                   Text;


   procedure ReportCondText (Cond      : in Boolean;
                             TrueText  : in String;
                             FalseText : in String);
   --# derives null from Cond,
   --#                   FalseText,
   --#                   TrueText;

end SparkMakeDebug;
