-- $Id: commandline.ads 11361 2008-10-07 10:02:38Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with EStrings;

--# inherit EStrings;

package CommandLine
--# own in State;
is

   procedure Setup;
   --# derives ;
   -- Set up so that Read reads command lines of the form:
   --    command /sw1=arg1 /sw2=arg2 /sw3 arg1 arg2

   procedure Read (Switch   : out EStrings.T;
                   Argument : out EStrings.T;
                   Success  : out Boolean);
   --# global in State;
   --# derives Argument,
   --#         Success,
   --#         Switch   from State;

end CommandLine;
