-- $Id: commandline.adb 15526 2010-01-07 13:41:57Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with GNAT.Command_Line;
with Ada.Characters.Latin_1;

package body CommandLine
is
   --# hide CommandLine; -- remainder is not SPARK.

   -- SwitchDelimiter is '-' on all platforms. This package is now *only* used
   -- by SPARKMake so no other tools are affected by this.
   SwitchDelimiter : constant Character := '-';
   SwitchArgSeparator : constant String := "=";

   --------------------------------------------------------------------------

   procedure Setup
   is
   begin
      GNAT.Command_Line.Initialize_Option_Scan
        (Switch_Char => SwitchDelimiter);
   end Setup;

   --------------------------------------------------------------------------

   procedure Read (Switch   : out EStrings.T;
                   Argument : out EStrings.T;
                   Success  : out Boolean)
   is
      TheSwitchString : EStrings.T;
      LCSwitchString  : EStrings.T;
      ArgFound        : Boolean;
      ArgPos          : EStrings.Positions;
      Char            : Character;
   begin
      -- set up default out parameters
      Switch := EStrings.Empty_String;
      Argument := EStrings.Empty_String;
      Success := False;

      -- Read the command line
      Char := GNAT.Command_Line.Getopt ("* *" & SwitchArgSeparator (1));

      if Char /= Ada.Characters.Latin_1.NUL then

         -- Get the current switch
         TheSwitchString := EStrings.Copy_String
           (Str => GNAT.Command_Line.Full_Switch);

         -- Convert to lower case
         LCSwitchString := EStrings.Lower_Case (E_Str => TheSwitchString);

         -- Is this a switch?
         if EStrings.Get_Element (E_Str => TheSwitchString,
                                  Pos   => EStrings.Positions'First) = SwitchDelimiter then

            -- Yes, does it have an argument?
            EStrings.Find_Sub_String
              (E_Str         => LCSwitchString,
               Search_String => SwitchArgSeparator,
               String_Found  => ArgFound,
               String_Start  => ArgPos);

            if ArgFound then
               -- Yes it has an argument
               Success := True;
               Switch := EStrings.Section
                 (E_Str     => LCSwitchString,
                  Start_Pos => 2,
                  Length    => ArgPos - 2);

               Argument := EStrings.Section
                 (E_Str     => TheSwitchString,
                  Start_Pos => ArgPos + 1,
                  Length    => EStrings.Get_Length (E_Str => TheSwitchString) - ArgPos);
            else
               -- No argument
               Success := True;
               Switch := EStrings.Section
                 (E_Str     => LCSwitchString,
                  Start_Pos => 2,
                  Length    => EStrings.Get_Length (E_Str => LCSwitchString) - 1);
            end if;

         else
            -- must be an argument
            Argument := EStrings.Copy_String (Str => GNAT.Command_Line.Full_Switch);
            Success := not EStrings.Is_Empty (E_Str => Argument);
         end if;
      end if;
   end Read;

end CommandLine;
