-- $Id: sparklalr_patab.adb 14467 2009-10-07 10:07:14Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_Common;
with Command_Line_Options;
with Sparklalr_Goto;
with Sparklalr_Memory;
with Sparklalr_Parser;
with Symbols_Dump;

package body Sparklalr_Patab
   --# own State is
   --#   Patab,
   --#   State_Table,
   --#   Pat_Seg_Count;
is

   type Patab_Elem is record
      Nact            : Integer;
      Other_Act       : Boolean;
      Check_Other_Act : Boolean;
   end record;
   type Patab_T is array (Sparklalr_Common.State_Range) of Patab_Elem;

   type State_Index_Pair is record
      Lower, Upper : Integer;
   end record;
   type State_Index is array (Sparklalr_Common.State_Range) of State_Index_Pair;

   Patab         : Patab_T;
   State_Table   : State_Index;
   Pat_Seg_Count : Integer;

   procedure Initialise
      --# global out Patab;
      --#        out Pat_Seg_Count;
      --#        out State_Table;
      --# derives Patab,
      --#         Pat_Seg_Count,
      --#         State_Table   from ;
   is
   begin
      Patab         := Patab_T'(others => Patab_Elem'(Nact => 0, Other_Act => False, Check_Other_Act => False));
      State_Table   := State_Index'(others => State_Index_Pair'(Lower => 0, Upper => 0));
      Pat_Seg_Count := 0;
      for I in Sparklalr_Common.State_Range loop
         Patab (I).Nact := I;
      end loop;
   end Initialise;

   procedure Pa_Out (F : in Sparklalr_IO.File_Type)
      --# global in     Sparklalr_Memory.Prod_Sum;
      --#        in     Sparklalr_Memory.Stat_No;
      --#        in     Symbols_Dump.State;
      --#        in out Patab;
      --#        in out Sparklalr_IO.Outputs;
      --#        in out Sparklalr_Parser.State;
      --#        in out State_Table;
      --# derives Patab,
      --#         Sparklalr_Parser.State from *,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Stat_No &
      --#         Sparklalr_IO.Outputs   from *,
      --#                                     F,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Prod_Sum,
      --#                                     Sparklalr_Memory.Stat_No,
      --#                                     Sparklalr_Parser.State,
      --#                                     State_Table,
      --#                                     Symbols_Dump.State &
      --#         State_Table            from *,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Stat_No,
      --#                                     Sparklalr_Parser.State;
   is

      procedure Aux_Pat_Out (F : in Sparklalr_IO.File_Type)
         --# global in     Sparklalr_Memory.Prod_Sum;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Symbols_Dump.State;
         --#        in out Patab;
         --#        in out Sparklalr_IO.Outputs;
         --#        in out Sparklalr_Parser.State;
         --#        in out State_Table;
         --# derives Patab,
         --#         Sparklalr_Parser.State from *,
         --#                                     Patab,
         --#                                     Sparklalr_Memory.Stat_No &
         --#         Sparklalr_IO.Outputs   from *,
         --#                                     F,
         --#                                     Patab,
         --#                                     Sparklalr_Memory.Prod_Sum,
         --#                                     Sparklalr_Memory.Stat_No,
         --#                                     Sparklalr_Parser.State,
         --#                                     Symbols_Dump.State &
         --#         State_Table            from *,
         --#                                     Patab,
         --#                                     Sparklalr_Memory.Stat_No,
         --#                                     Sparklalr_Parser.State;
      is
         J                : Integer;
         Other_Acts_There : Boolean;
         Curr_Pat_Index   : Integer;
      begin
         Curr_Pat_Index   := 1;
         Other_Acts_There := False;
         Sparklalr_IO.Put_Line (F, "  ParseActionTable : constant AuxPAT := AuxPAT'(");
         Sparklalr_IO.Put_Line (F, "-- STATE INDEX");
         for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
            if not Patab (I).Other_Act then
               if I > 1 then
                  Sparklalr_IO.Put_Line (F, ",");
               end if;
               State_Table (I).Lower := Curr_Pat_Index;
               Sparklalr_IO.Put (F, "----- ");
               Sparklalr_IO.Put_Int (F, I, 1);
               Sparklalr_IO.New_Line (F);
               Sparklalr_IO.Put_Int (F, Curr_Pat_Index, 5);
               Sparklalr_IO.Put (F, " => ");
               Sparklalr_Parser.Action_Gen_Pa_Out (F, I, Curr_Pat_Index);
               State_Table (I).Upper     := Curr_Pat_Index - 1;
               Other_Acts_There          := True;
            end if;
         end loop;
         for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
            if Patab (I).Check_Other_Act then
               if Other_Acts_There then
                  Sparklalr_IO.Put_Line (F, ",");
               else
                  Other_Acts_There := True;
               end if;
               J := I;
               Sparklalr_IO.Put (F, "----- ");
               Sparklalr_IO.Put_Int (F, J, 1);
               Sparklalr_IO.New_Line (F);
               loop
                  J                         := Patab (J).Nact;
                  Patab (J).Check_Other_Act := False;
                  Sparklalr_IO.Put (F, "----- ");
                  Sparklalr_IO.Put_Int (F, J, 1);
                  Sparklalr_IO.New_Line (F);
                  exit when Patab (J).Nact = J;
               end loop;
            end if;
            if Patab (I).Other_Act then
               J                     := I;
               State_Table (I).Lower := Curr_Pat_Index;
               Sparklalr_IO.Put_Int (F, Curr_Pat_Index, 5);
               Sparklalr_IO.Put (F, " => ");
               Sparklalr_Parser.Action_Gen_Pa_Out (F, J, Curr_Pat_Index);
               State_Table (I).Upper := Curr_Pat_Index - 1;
               loop
                  J                   := Patab (J).Nact;
                  Patab (J).Other_Act := False;
                  State_Table (J)     := State_Table (I);
                  exit when Patab (J).Nact = J;
               end loop;
            end if;
         end loop;
         Sparklalr_IO.Put_Line (F, ");");
      end Aux_Pat_Out;

      procedure Main_Pat_Out (F : in Sparklalr_IO.File_Type)
         --# global in     Sparklalr_Memory.Stat_No;
         --#        in     State_Table;
         --#        in out Sparklalr_IO.Outputs;
         --# derives Sparklalr_IO.Outputs from *,
         --#                                   F,
         --#                                   Sparklalr_Memory.Stat_No,
         --#                                   State_Table;
      is
      begin
         Sparklalr_IO.Put_Line (F, "  StateTable : constant MainPAT := MainPAT'(");
         Sparklalr_IO.Put_Line (F, "-- STATE");
         for State_Var in Integer range 1 .. Sparklalr_Memory.Get_Stat_No - 1 loop
            Sparklalr_IO.Put_Int (F, State_Var, 5);
            Sparklalr_IO.Put (F, " => PATIndexPair'(");
            Sparklalr_IO.Put_Int (F, State_Table (State_Var).Lower, 1);
            Sparklalr_IO.Put (F, ", ");
            Sparklalr_IO.Put_Int (F, State_Table (State_Var).Upper, 1);
            Sparklalr_IO.Put_Line (F, "),");
         end loop;
         Sparklalr_IO.Put_Int (F, Sparklalr_Memory.Get_Stat_No, 5);
         Sparklalr_IO.Put (F, " => PATIndexPair'(");
         Sparklalr_IO.Put_Int (F, State_Table (Sparklalr_Memory.Get_Stat_No).Lower, 1);
         Sparklalr_IO.Put (F, ", ");
         Sparklalr_IO.Put_Int (F, State_Table (Sparklalr_Memory.Get_Stat_No).Upper, 1);
         Sparklalr_IO.Put_Line (F, "));");
      end Main_Pat_Out;

   begin
      Sparklalr_IO.Put_Line (F, "   Default : constant SPSymbols.SPTerminal := SPSymbols.SPDEFAULT;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put (F, "   NoOfPATEntries : constant POSITIVE := ");
      Sparklalr_IO.Put_Int (F, Sparklalr_Parser.Get_Pat_Count, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   type PATIndex is range 1 .. NoOfPATEntries;");
      Sparklalr_IO.Put_Line (F, "   type SymActionPair is record");
      Sparklalr_IO.Put_Line (F, "      TermSym : SPSymbols.SPTerminal;");
      Sparklalr_IO.Put_Line (F, "      ParseAction : SPParseAct;");
      Sparklalr_IO.Put_Line (F, "   end record;");
      Sparklalr_IO.Put_Line (F, "   pragma PACK(SymActionPair);");
      Sparklalr_IO.Put_Line (F, "   type AuxPAT is array (PATIndex) of SymActionPair;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   type PATIndexPair is record");
      Sparklalr_IO.Put_Line (F, "      Lower, Upper : PATIndex;");
      Sparklalr_IO.Put_Line (F, "   end record;");
      Sparklalr_IO.Put_Line (F, "   pragma PACK(PATIndexPair);");
      Sparklalr_IO.Put_Line (F, "   type MainPAT is array (SPProductions.ValidStates) of PATIndexPair;");
      Sparklalr_IO.New_Line (F);
      Aux_Pat_Out (F);
      Sparklalr_IO.New_Line (F);
      Main_Pat_Out (F);
   end Pa_Out;

   procedure Pa_Out_Sp (F : in Sparklalr_IO.File_Type)
      --# global in     Sparklalr_Memory.Max_Right;
      --#        in     Sparklalr_Memory.Prod_Sum;
      --#        in     Sparklalr_Memory.Stat_No;
      --#        in     Symbols_Dump.State;
      --#        in out Patab;
      --#        in out Sparklalr_IO.Outputs;
      --#        in out Sparklalr_Parser.State;
      --#        in out State_Table;
      --# derives Patab,
      --#         Sparklalr_Parser.State from *,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Stat_No &
      --#         Sparklalr_IO.Outputs   from *,
      --#                                     F,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Max_Right,
      --#                                     Sparklalr_Memory.Prod_Sum,
      --#                                     Sparklalr_Memory.Stat_No,
      --#                                     Sparklalr_Parser.State,
      --#                                     State_Table,
      --#                                     Symbols_Dump.State &
      --#         State_Table            from *,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Stat_No,
      --#                                     Sparklalr_Parser.State;
   is

      Max_Right_Power2, Packed_Symact_Max, Terminal_Count_P2, Non_Terminal_Count_P2, State_Count_P2, Prod_Count_P2, Pat_Index_P2 :
        Integer;

      procedure Aux_Pat_Out (F : in Sparklalr_IO.File_Type)
         --# global in     Sparklalr_Memory.Prod_Sum;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Symbols_Dump.State;
         --#        in out Patab;
         --#        in out Sparklalr_IO.Outputs;
         --#        in out Sparklalr_Parser.State;
         --#        in out State_Table;
         --# derives Patab,
         --#         Sparklalr_Parser.State from *,
         --#                                     Patab,
         --#                                     Sparklalr_Memory.Stat_No &
         --#         Sparklalr_IO.Outputs   from *,
         --#                                     F,
         --#                                     Patab,
         --#                                     Sparklalr_Memory.Prod_Sum,
         --#                                     Sparklalr_Memory.Stat_No,
         --#                                     Sparklalr_Parser.State,
         --#                                     Symbols_Dump.State &
         --#         State_Table            from *,
         --#                                     Patab,
         --#                                     Sparklalr_Memory.Stat_No,
         --#                                     Sparklalr_Parser.State;
      is
         J                : Integer;
         Other_Acts_There : Boolean;
         Curr_Pat_Index   : Integer;
      begin
         Curr_Pat_Index   := 1;
         Other_Acts_There := False;
         Sparklalr_IO.Put_Line (F, "   ParseActionTable : constant AuxPAT := AuxPAT'(");
         Sparklalr_IO.Put_Line (F, "-- STATE INDEX");
         for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
            if not Patab (I).Other_Act then
               if I > 1 then
                  Sparklalr_IO.Put_Line (F, ",");
               end if;
               State_Table (I).Lower := Curr_Pat_Index;
               Sparklalr_IO.Put (F, "----- ");
               Sparklalr_IO.Put_Int (F, I, 1);
               Sparklalr_IO.New_Line (F);
               Sparklalr_IO.Put_Int (F, Curr_Pat_Index, 5);
               Sparklalr_IO.Put (F, " => ");
               Sparklalr_Parser.Action_Gen_Pa_Out_Sp (F, I, Curr_Pat_Index);
               State_Table (I).Upper := Curr_Pat_Index - 1;
               Other_Acts_There      := True;
            end if;
         end loop;
         for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
            if Patab (I).Check_Other_Act then
               if Other_Acts_There then
                  Sparklalr_IO.Put_Line (F, ",");
               else
                  Other_Acts_There := True;
               end if;
               J := I;
               Sparklalr_IO.Put (F, "----- ");
               Sparklalr_IO.Put_Int (F, J, 1);
               Sparklalr_IO.New_Line (F);
               loop
                  J                         := Patab (J).Nact;
                  Patab (J).Check_Other_Act := False;
                  Sparklalr_IO.Put (F, "----- ");
                  Sparklalr_IO.Put_Int (F, J, 1);
                  Sparklalr_IO.New_Line (F);
                  exit when Patab (J).Nact = J;
               end loop;
            end if;
            if Patab (I).Other_Act then
               J                         := I;
               State_Table (I).Lower := Curr_Pat_Index;
               Sparklalr_IO.Put_Int (F, Curr_Pat_Index, 5);
               Sparklalr_IO.Put (F, " => ");
               Sparklalr_Parser.Action_Gen_Pa_Out_Sp (F, J, Curr_Pat_Index);
               State_Table (I).Upper := Curr_Pat_Index - 1;
               loop
                  J                   := Patab (J).Nact;
                  Patab (J).Other_Act := False;
                  State_Table (J)     := State_Table (I);
                  exit when Patab (J).Nact = J;
               end loop;
            end if;
         end loop;
         Sparklalr_IO.Put_Line (F, ");");
      end Aux_Pat_Out;

      procedure Main_Pat_Out (F : in Sparklalr_IO.File_Type)
         --# global in     Sparklalr_Memory.Stat_No;
         --#        in     State_Table;
         --#        in out Sparklalr_IO.Outputs;
         --# derives Sparklalr_IO.Outputs from *,
         --#                                   F,
         --#                                   Sparklalr_Memory.Stat_No,
         --#                                   State_Table;
      is
      begin
         Sparklalr_IO.Put_Line (F, "   StateTable : constant MainPAT := MainPAT'(");
         Sparklalr_IO.Put_Line (F, "-- STATE");
         for State_Var in Integer range 1 .. Sparklalr_Memory.Get_Stat_No - 1 loop
            Sparklalr_IO.Put_Int (F, State_Var, 5);
            Sparklalr_IO.Put (F, " => LowerPATIndex * ");
            Sparklalr_IO.Put_Int (F, State_Table (State_Var).Lower, 1);
            Sparklalr_IO.Put (F, " + UpperPATIndex * ");
            Sparklalr_IO.Put_Int (F, State_Table (State_Var).Upper, 1);
            Sparklalr_IO.Put_Line (F, ",");
         end loop;
         Sparklalr_IO.Put_Int (F, Sparklalr_Memory.Get_Stat_No, 5);
         Sparklalr_IO.Put (F, " => LowerPATIndex * ");
         Sparklalr_IO.Put_Int (F, State_Table (Sparklalr_Memory.Get_Stat_No).Lower, 1);
         Sparklalr_IO.Put (F, " + UpperPATIndex * ");
         Sparklalr_IO.Put_Int (F, State_Table (Sparklalr_Memory.Get_Stat_No).Upper, 1);
         Sparklalr_IO.Put_Line (F, ");");
      end Main_Pat_Out;

   begin
      Terminal_Count_P2 := 0;
      while 2 ** Terminal_Count_P2 <= Symbols_Dump.Get_Nterms loop
         Terminal_Count_P2 := Terminal_Count_P2 + 1;
      end loop;
      Non_Terminal_Count_P2 := 0;
      while 2 ** Non_Terminal_Count_P2 <= Symbols_Dump.Get_Nnon_Terms loop
         Non_Terminal_Count_P2 := Non_Terminal_Count_P2 + 1;
      end loop;
      State_Count_P2 := 0;
      while 2 ** State_Count_P2 <= Sparklalr_Memory.Get_Stat_No loop
         State_Count_P2 := State_Count_P2 + 1;
      end loop;
      Prod_Count_P2    := 0;
      Max_Right_Power2 := 0;
      while 2 ** Max_Right_Power2 <= Sparklalr_Memory.Get_Max_Right loop
         Max_Right_Power2 := Max_Right_Power2 + 1;
      end loop;
      if ((2 + Terminal_Count_P2) + State_Count_P2) >
         ((((2 + Terminal_Count_P2) + Non_Terminal_Count_P2) + Max_Right_Power2) + Prod_Count_P2) then
         Packed_Symact_Max := (2 + Terminal_Count_P2) + State_Count_P2;
      else
         Packed_Symact_Max :=
           (((2 + Terminal_Count_P2) +
               Non_Terminal_Count_P2) +
              Max_Right_Power2) +
           Prod_Count_P2;
      end if;
      Pat_Index_P2 := 0;
      while 2 ** Pat_Index_P2 <= Sparklalr_Parser.Get_Pat_Count loop
         Pat_Index_P2 := Pat_Index_P2 + 1;
      end loop;
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put (F, "   NoOfPATEntries : constant Positive := ");
      Sparklalr_IO.Put_Int (F, Sparklalr_Parser.Get_Pat_Count, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   type PATIndex is range 1 .. NoOfPATEntries;");
      Sparklalr_IO.Put (F, "   type PackedSymActionPair is range 0 .. 2**");
      Sparklalr_IO.Put_Int (F, Packed_Symact_Max, 1);
      Sparklalr_IO.Put_Line (F, "-1;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   ActLim : constant PackedSymActionPair := 2**2;");
      Sparklalr_IO.Put (F, "   TermSymLim : constant PackedSymActionPair := 2**");
      Sparklalr_IO.Put_Int (F, Terminal_Count_P2, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put (F, "   StateLim : constant PackedSymActionPair := 2**");
      Sparklalr_IO.Put_Int (F, State_Count_P2, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put (F, "   SymbolLim : constant PackedSymActionPair := 2**");
      Sparklalr_IO.Put_Int (F, Non_Terminal_Count_P2, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put (F, "   RedByLim : constant PackedSymActionPair := 2**");
      Sparklalr_IO.Put_Int (F, Max_Right_Power2, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put (F, "   ProdNoLim : constant PackedSymActionPair := 2**");
      Sparklalr_IO.Put_Int (F, Prod_Count_P2, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put_Line (F, "   pragma Unreferenced (ProdNoLim);");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   TermSym : constant PackedSymActionPair := 1;");
      Sparklalr_IO.Put_Line (F, "   Act : constant PackedSymActionPair := TermSym * TermSymLim;");
      Sparklalr_IO.Put_Line (F, "   State : constant PackedSymActionPair := Act * ActLim;");
      Sparklalr_IO.Put_Line (F, "   Symbol : constant PackedSymActionPair := Act * ActLim;");
      Sparklalr_IO.Put_Line (F, "   RedBy : constant PackedSymActionPair := Symbol * SymbolLim;");
      Sparklalr_IO.Put_Line (F, "   ProdNo : constant PackedSymActionPair := 0;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   FirstNonTerminal : constant PackedSymActionPair :=");
      Sparklalr_IO.Put_Line (F, "      SPSymbols.SPNonTerminal'Pos (");
      Sparklalr_IO.Put_Line (F, "         SPSymbols.SPNonTerminal'First);");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   type AuxPAT is array (PATIndex) of PackedSymActionPair;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put (F, "   Default : constant PackedSymActionPair :=");
      Sparklalr_IO.Put_Line (F, "      SPSymbols.SPTerminal'Pos (SPSymbols.SPDEFAULT);");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put (F, "   ErrorAct  : constant PackedSymActionPair :=");
      Sparklalr_IO.Put_Line (F, "      Act * SPActionKind'Pos (Error);");
      Sparklalr_IO.Put_Line (F, "   pragma Unreferenced (ErrorAct);");
      Sparklalr_IO.Put (F, "   ShiftAct  : constant PackedSymActionPair :=");
      Sparklalr_IO.Put_Line (F, "      Act * SPActionKind'Pos (Shift);");
      Sparklalr_IO.Put (F, "   ReduceAct  : constant PackedSymActionPair :=");
      Sparklalr_IO.Put_Line (F, "      Act * SPActionKind'Pos (Reduce);");
      Sparklalr_IO.Put (F, "   AcceptAct : constant PackedSymActionPair :=");
      Sparklalr_IO.Put_Line (F, "      Act * SPActionKind'Pos (Accpt);");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put (F, "   type PackedPATIndexPair is range 0 .. 2**");
      Sparklalr_IO.Put_Int (F, 2 * Pat_Index_P2, 1);
      Sparklalr_IO.Put_Line (F, "-1;");
      Sparklalr_IO.Put (F, "   PATIndexSize : constant PackedPATIndexPair := 2**");
      Sparklalr_IO.Put_Int (F, Pat_Index_P2, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put_Line (F, "   LowerPATIndex : constant PackedPATIndexPair := 1;");
      Sparklalr_IO.Put_Line (F, "   UpperPATIndex : constant PackedPATIndexPair := PATIndexSize;");
      Sparklalr_IO.Put_Line (F, "   type MainPAT is array (SPProductions.ValidStates)");
      Sparklalr_IO.Put_Line (F, "      of PackedPATIndexPair;");
      Sparklalr_IO.New_Line (F);
      Aux_Pat_Out (F);
      Sparklalr_IO.New_Line (F);
      Main_Pat_Out (F);
   end Pa_Out_Sp;

   -- These procedures calculate the SPARK parser table sizes prior to output
   procedure Calc_Table_Sizes
      --# global in     Sparklalr_Memory.Stat_No;
      --#        in     Symbols_Dump.State;
      --#        in out Patab;
      --#        in out Sparklalr_Goto.State;
      --#        in out Sparklalr_Parser.State;
      --#           out Pat_Seg_Count;
      --# derives Patab,
      --#         Sparklalr_Parser.State from *,
      --#                                     Patab,
      --#                                     Sparklalr_Memory.Stat_No &
      --#         Pat_Seg_Count          from Patab,
      --#                                     Sparklalr_Memory.Stat_No,
      --#                                     Sparklalr_Parser.State &
      --#         Sparklalr_Goto.State   from *,
      --#                                     Symbols_Dump.State;
   is
      J, Seg_Count : Integer;
   begin
      Pat_Seg_Count := 0;
      Sparklalr_Parser.Init_Pat_Count;
      for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
         Seg_Count := Sparklalr_Parser.Get_Pat_Count;
         if not Patab (I).Check_Other_Act then
            Sparklalr_Parser.Action_Gen (I);
         end if;
         if Sparklalr_Parser.Get_Pat_Count - Seg_Count > Pat_Seg_Count then
            Pat_Seg_Count := Sparklalr_Parser.Get_Pat_Count - Seg_Count;
         end if;
      end loop;
      for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
         Seg_Count := Sparklalr_Parser.Get_Pat_Count;
         if Patab (I).Check_Other_Act then
            J := I;
            Sparklalr_Parser.Action_Gen (J);
            loop
               J                         := Patab (J).Nact;
               Patab (J).Check_Other_Act := False;
               exit when Patab (J).Nact = J;
            end loop;
         end if;
         if Sparklalr_Parser.Get_Pat_Count - Seg_Count > Pat_Seg_Count then
            Pat_Seg_Count := Sparklalr_Parser.Get_Pat_Count - Seg_Count;
         end if;
      end loop;
      for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
         Patab (I).Check_Other_Act := Patab (I).Other_Act;
      end loop;
      for I in Integer range 2 .. Symbols_Dump.Get_Nnon_Terms loop
         Sparklalr_Goto.Go_Out (I);
      end loop;
   end Calc_Table_Sizes;

   procedure Optimise
      -- SET UP THE PATAB DATA STRUCTURE
      -- SO THAT OPTIMISATION OF THE PASCAL PARSING ACTION FUNCTION IS
      -- CARRIED OUT
      --# global in     Command_Line_Options.State;
      --#        in     Sparklalr_Memory.Stat_No;
      --#        in     Sparklalr_Parser.State;
      --#        in out Patab;
      --#        in out Sparklalr_IO.Outputs;
      --# derives Patab                from *,
      --#                                   Sparklalr_Memory.Stat_No,
      --#                                   Sparklalr_Parser.State &
      --#         Sparklalr_IO.Outputs from *,
      --#                                   Command_Line_Options.State,
      --#                                   Patab,
      --#                                   Sparklalr_Memory.Stat_No,
      --#                                   Sparklalr_Parser.State;
   is
      I : Integer;
   begin
      for Istart in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
         I := Istart;
         if not Patab (I).Other_Act then
            for J in Integer range I + 1 .. Sparklalr_Memory.Get_Stat_No loop
               if Patab (J).Nact = J then
                  if Sparklalr_Parser.Action_Equal (Sparklalr_Parser.Get_Pa_List (I), Sparklalr_Parser.Get_Pa_List (J)) then
                     --# accept F, 41, "Stable expression here expected and OK";
                     if Command_Line_Options.Get_Debug_Level (6) then
                        Sparklalr_IO.Put (Sparklalr_IO.Standard_Output, " MERGING ACTIONS ");
                        Sparklalr_IO.Put_Int (Sparklalr_IO.Standard_Output, I, 3);
                        Sparklalr_IO.Put (Sparklalr_IO.Standard_Output, " AND ");
                        Sparklalr_IO.Put_Int (Sparklalr_IO.Standard_Output, J, 3);
                        Sparklalr_IO.New_Line (Sparklalr_IO.Standard_Output);
                     end if;
                     --# end accept;
                     Patab (I).Other_Act       := True;
                     Patab (I).Check_Other_Act := True;
                     Patab (I).Nact            := J;
                     Patab (J).Other_Act       := True;
                     Patab (J).Check_Other_Act := True;
                     I                         := J;
                  end if;
               end if;
            end loop;
         end if;
      end loop;
   end Optimise;

   procedure Opt_Stats (F : in Sparklalr_IO.File_Type)
      --# global in     Patab;
      --#        in     Sparklalr_Memory.Stat_No;
      --#        in out Sparklalr_IO.Outputs;
      --# derives Sparklalr_IO.Outputs from *,
      --#                                   F,
      --#                                   Patab,
      --#                                   Sparklalr_Memory.Stat_No;
   is
      J : Integer;
   begin
      J := 0;
      for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
         if Patab (I).Other_Act then
            J := J + 1;
         end if;
      end loop;
      Sparklalr_IO.Put_Int (F, J, 6);
      Sparklalr_IO.Put_Line (F, " PARSING ACTIONS OPTIMISED BY CASE LABEL MERGE");
   end Opt_Stats;

   function Get_Pat_Seg_Count return Integer
      --# global in Pat_Seg_Count;
        is
   begin
      return Pat_Seg_Count;
   end Get_Pat_Seg_Count;

end Sparklalr_Patab;
