-- $Id: sparklalr_memory.adb 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

package body Sparklalr_Memory is

   procedure Initialise is
   begin
      Stat_No   := 0;
      Prod_Sum  := Prod_Sum_T'(others => Prod_Sum_Row_T'(others => 0));
      Prod_No   := 2;
      Max_Right := 0;
   end Initialise;

   -- Getter
   function Get_Stat_No return Integer is
   begin
      return Stat_No;
   end Get_Stat_No;

   function Get_Prod_No return  Sparklalr_Common.Production_Index is
   begin
      return Prod_No;
   end Get_Prod_No;

   function Get_Prod_Sum (I : in Sparklalr_Common.Production_Index; J : in Positive) return Integer is
   begin
      return Prod_Sum (I)(J);
   end Get_Prod_Sum;

   function Get_Max_Right return Integer is
   begin
      return Max_Right;
   end Get_Max_Right;

   procedure Set_Union (A : in out Symbol_Set_T; B : in Symbol_Set_T; Elements_Added_To_A : out Boolean) is
   begin
      Elements_Added_To_A := False;
      for Sym in Sparklalr_Common.Sym_Range loop
         if B (Sym) and not A (Sym) then
            A (Sym)             := True;
            Elements_Added_To_A := True;
         end if;
      end loop;
   end Set_Union;

   function Get_Symbol_Set (Symbol_Set : in Symbol_Set_T; I : in Sparklalr_Common.Sym_Range) return Boolean is
   begin
      return Symbol_Set (I);
   end Get_Symbol_Set;

   procedure Set_Stat_No (Val : in Integer) is
   begin
      Stat_No := Val;
   end Set_Stat_No;

   procedure Set_Prod_No (Val : in Sparklalr_Common.Production_Index) is
   begin
      Prod_No := Val;
   end Set_Prod_No;

   procedure Set_Prod_Sum (I : in Sparklalr_Common.Production_Index; J : in One_Two; Val : in Integer) is
   begin
      Prod_Sum (I)(J) := Val;
   end Set_Prod_Sum;

   procedure Set_Max_Right (Val : in Integer) is
   begin
      Max_Right := Val;
   end Set_Max_Right;

end Sparklalr_Memory;
