-- $Id: sparklalr_memory-left_corner.adb 14467 2009-10-07 10:07:14Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Command_Line_Options;
with Sparklalr_Common;
with Sparklalr_Memory.Dump;
with Symbols_Dump;

package body Sparklalr_Memory.Left_Corner
   --# own State is
   --#   Left_Corner_Count,
   --#   Left_Corners;
is

   -- ---- These types are used in the generation of the SPARK parser Tables ----
   type Left_Corner_Entry is record
      Lower, Upper        : Integer;
      Left_Corner_Symbols : Sparklalr_Memory.Symbol_Set_T;
      Other_Symbol        : Boolean;
      Base_Symbol         : Sparklalr_Common.Non_Term_Range;
   end record;
   type Left_Corner_Tab is array (Sparklalr_Common.Non_Term_Range) of Left_Corner_Entry;

   Left_Corner_Count : Integer;
   Left_Corners      : Left_Corner_Tab;

   procedure Count_Left_Corners
      --# global in     Symbols_Dump.State;
      --#        in out Left_Corners;
      --#        in out Left_Corner_Count;
      --# derives Left_Corners,
      --#         Left_Corner_Count from Left_Corners,
      --#                                Left_Corner_Count,
      --#                                Symbols_Dump.State;
   is
   begin
      for Nt in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms loop
         if Left_Corners (Nt).Base_Symbol /= Nt then
            Left_Corners (Nt).Lower := Left_Corners (Left_Corners (Nt).Base_Symbol).Lower;
            Left_Corners (Nt).Upper := Left_Corners (Left_Corners (Nt).Base_Symbol).Upper;
         else
            Left_Corners (Nt).Lower := Left_Corner_Count;
            for Sym in Integer range 0 .. Symbols_Dump.Get_Nterms loop
               if Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt).Left_Corner_Symbols, Sym) then
                  Left_Corner_Count := Left_Corner_Count + 1;
               end if;
            end loop;
            for Sym in Integer range Sparklalr_Common.Nt_Base + 1 .. Sparklalr_Common.Nt_Base + Symbols_Dump.Get_Nnon_Terms loop
               if Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt).Left_Corner_Symbols, Sym) then
                  Left_Corner_Count := Left_Corner_Count + 1;
               end if;
            end loop;
            Left_Corners (Nt).Upper := Left_Corner_Count - 1;
         end if;
      end loop;
   end Count_Left_Corners;

   procedure Gen_Left_Corner
      --# global in     Dump.State;
      --#        in     Symbols_Dump.State;
      --#           out Left_Corners;
      --#           out Left_Corner_Count;
      --# derives Left_Corners      from Dump.State,
      --#                                Symbols_Dump.State &
      --#         Left_Corner_Count from ;
   is

      C                         : Sparklalr_Common.Sym_Range;
      S, T                      : Dump.Pt_Memory;
      Not_Closed, Element_Added : Boolean;
      B                         : Sparklalr_Memory.Symbol_Set_T;

      procedure Merge_Left_Corner_Groups
         --# global in     Symbols_Dump.State;
         --#        in out Left_Corners;
         --# derives Left_Corners from *,
         --#                           Symbols_Dump.State;
      is
         Sym      : Sparklalr_Common.Sym_Range;
         The_Same : Boolean;
      begin
         if Symbols_Dump.Get_Nnon_Terms > 0 then
            for Nt1 in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms loop
               if Nt1 - 1 > 0 then
                  for Nt2 in Integer range 1 .. Nt1 - 1 loop
                     if Left_Corners (Nt2).Base_Symbol = Nt2 then
                        The_Same := True;
                        Sym      := 0;
                        while The_Same and (Sym <= Symbols_Dump.Get_Nterms) loop
                           The_Same := Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt1).Left_Corner_Symbols, Sym) =
                                       Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt2).Left_Corner_Symbols, Sym);
                           Sym      := Sym + 1;
                        end loop;
                        Sym := 1;
                        while The_Same and (Sym <= Symbols_Dump.Get_Nnon_Terms) loop
                           The_Same :=
                             Sparklalr_Memory.Get_Symbol_Set
                                  (Left_Corners (Nt1).Left_Corner_Symbols,
                                   Sym + Sparklalr_Common.Nt_Base) =
                             Sparklalr_Memory.Get_Symbol_Set
                                (Left_Corners (Nt2).Left_Corner_Symbols,
                                 Sym + Sparklalr_Common.Nt_Base);
                           Sym      := Sym + 1;
                        end loop;
                        if The_Same then
                           Left_Corners (Nt2).Other_Symbol := True;
                           Left_Corners (Nt1).Base_Symbol  := Nt2;
                        end if;
                     end if;
                  end loop;
               end if;
            end loop;
         end if;
      end Merge_Left_Corner_Groups;

   begin
      Left_Corner_Count := 1;
      Left_Corners      :=
        Left_Corner_Tab'
        (others =>
           Left_Corner_Entry'(Lower               => 0,
                              Upper               => 0,
                              Left_Corner_Symbols => Sparklalr_Memory.Symbol_Set_T'(others => False),
                              Other_Symbol        => False,
                              Base_Symbol         => 1));
      for Nt in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms loop
         for Sym_Set_El in Sparklalr_Common.Sym_Range loop
            Left_Corners (Nt).Left_Corner_Symbols (Sym_Set_El) := False;
         end loop;
         Left_Corners (Nt).Other_Symbol := False;
         Left_Corners (Nt).Base_Symbol  := Nt;
      end loop;
      -- Form closure of LeftCorner
      Not_Closed := True;
      while Not_Closed loop
         Not_Closed := False;
         for Nt in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms loop
            S := Dump.Get_Ntrdn (Nt);
            T := Dump.Get_Ntrdn (Nt + 1);
            while S /= T loop
               if Dump.Get_Contents (Dump.Get_Next (Dump.Get_Mem_Pt (S))) >= 0 then
                  C := Dump.Get_Contents (Dump.Get_Next (Dump.Get_Mem_Pt (S)));
                  if not Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt).Left_Corner_Symbols, C) then
                     Left_Corners (Nt).Left_Corner_Symbols (C) := True;
                     Not_Closed                                := True;
                  end if;
                  if C > Sparklalr_Common.Nt_Base then
                     B := Left_Corners (C - Sparklalr_Common.Nt_Base).Left_Corner_Symbols;
                     Sparklalr_Memory.Set_Union (Left_Corners (Nt).Left_Corner_Symbols, B, Element_Added);
                     Not_Closed := Not_Closed or Element_Added;
                  end if;
               end if;
               S := Dump.Get_Next (S);
            end loop;
         end loop;
      end loop;
      Merge_Left_Corner_Groups;
   end Gen_Left_Corner;

   procedure Out_Left_Corner (F : in Sparklalr_IO.File_Type)
      --# global in     Command_Line_Options.State;
      --#        in     Dump.State;
      --#        in     Left_Corners;
      --#        in     Left_Corner_Count;
      --#        in     Symbols_Dump.State;
      --#        in out Sparklalr_IO.Outputs;
      --# derives Sparklalr_IO.Outputs from *,
      --#                                   Command_Line_Options.State,
      --#                                   Dump.State,
      --#                                   F,
      --#                                   Left_Corners,
      --#                                   Left_Corner_Count,
      --#                                   Symbols_Dump.State;
   is
      Pos, Index, Left_Corners_P2 : Integer;
      Comma_Required              : Boolean;
   begin
      Sparklalr_IO.Put_Line (F, "with SPSymbols;");
      Sparklalr_IO.Put_Line (F, "use type SPSymbols.SPSymbol;");
      Sparklalr_IO.Put_Line (F, "--# inherit SPSymbols;");
      Sparklalr_IO.Put_Line (F, "package SPRelations");
      Sparklalr_IO.Put_Line (F, "is");
      Sparklalr_IO.Put_Line (F, "   function SPLeftCorner (Parent : SPSymbols.SPSymbol;");
      Sparklalr_IO.Put_Line (F, "                          Child  : SPSymbols.SPSymbol) return Boolean;");
      Sparklalr_IO.Put_Line (F, "   function SPTerminalLike (Sym : SPSymbols.SPSymbol) return Boolean;");
      Sparklalr_IO.Put_Line (F, "end SPRelations;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "package body SPRelations is");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   --# hide SPRelations;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put (F, "   NoOfLeftCorners : constant Natural := ");
      Sparklalr_IO.Put_Int (F, Left_Corner_Count - 1, 1);
      Sparklalr_IO.Put_Line (F, ";");
      Sparklalr_IO.Put_Line (F, "   type LeftCornerRange is range 1 .. NoOfLeftCorners;");
      Sparklalr_IO.Put_Line (F, "   type LeftCornerRel is array (LeftCornerRange) of SPSymbols.SPSymbol;");
      Sparklalr_IO.New_Line (F);
      if Command_Line_Options.Get_Self_Pack then
         Left_Corners_P2 := 0;
         while 2 ** Left_Corners_P2 <= Left_Corner_Count - 1 loop
            Left_Corners_P2 := Left_Corners_P2 + 1;
         end loop;
         Sparklalr_IO.Put (F, "   type RelationEntry is range 0 .. 2**");
         Sparklalr_IO.Put_Int (F, 2 * Left_Corners_P2 + 1, 1);
         Sparklalr_IO.Put_Line (F, "-1;");
         Sparklalr_IO.New_Line (F);
         Sparklalr_IO.Put_Line (F, "   TermLikeLim : constant RelationEntry := 2;");
         Sparklalr_IO.Put (F, "   LowLim : constant RelationEntry := 2**");
         Sparklalr_IO.Put_Int (F, Left_Corners_P2, 1);
         Sparklalr_IO.Put_Line (F, ";");
         Sparklalr_IO.Put (F, "   HighLim : constant RelationEntry := 2**");
         Sparklalr_IO.Put_Int (F, Left_Corners_P2, 1);
         Sparklalr_IO.Put_Line (F, ";");
         Sparklalr_IO.Put_Line (F, "   TerminalLike : constant RelationEntry := 1;");
         Sparklalr_IO.Put_Line (F, "   Low : constant RelationEntry := TerminalLike * TermLikeLim;");
         Sparklalr_IO.Put_Line (F, "   High : constant RelationEntry := Low * LowLim;");
      else
         Sparklalr_IO.Put_Line (F, "   type RelationEntry is record");
         Sparklalr_IO.Put_Line (F, "      TerminalLike : Boolean;");
         Sparklalr_IO.Put_Line (F, "      Low, High : LeftCornerRange;");
         Sparklalr_IO.Put_Line (F, "   end record;");
      end if;
      Sparklalr_IO.Put_Line (F, "   type RelationTable is array (SPSymbols.SPNonTerminal) of RelationEntry;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   LeftCorner : constant LeftCornerRel := LeftCornerRel'(");
      Comma_Required := False;
      Index          := 1;
      for Nt in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms loop
         if Left_Corners (Nt).Base_Symbol = Nt then
            if Left_Corners (Nt).Other_Symbol then
               for Subordinate in Integer range Nt + 1 .. Symbols_Dump.Get_Nnon_Terms loop
                  if Left_Corners (Subordinate).Base_Symbol = Nt then
                     if Comma_Required then
                        Sparklalr_IO.Put_Line (F, ",");
                     end if;
                     Comma_Required := False;
                     Sparklalr_Common.Put_N_Chars (F, ' ', 3);
                     Sparklalr_IO.Put (F, "-- ");
                     Pos := 7;
                     --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
                     Sparklalr_Common.Print2
                       (F,
                        Sparklalr_Common.Sp_Symbol_Str,
                        Symbols_Dump.Get_Nterm_Set (Subordinate),
                        Pos,
                        7,
                        False);
                     --# end accept;
                     Sparklalr_IO.New_Line (F);
                  end if;
               end loop;
            end if;
            if Comma_Required then
               Sparklalr_IO.Put_Line (F, ",");
            end if;
            Comma_Required := False;
            Sparklalr_Common.Put_N_Chars (F, ' ', 3);
            Sparklalr_IO.Put (F, "-- ");
            Pos := 7;
            --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
            Sparklalr_Common.Print2 (F, Sparklalr_Common.Sp_Symbol_Str, Symbols_Dump.Get_Nterm_Set (Nt), Pos, 7, False);
            --# end accept;
            Sparklalr_IO.Put_Line (F, " =>");
            for Sym in Integer range 0 .. Symbols_Dump.Get_Nterms loop
               if Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt).Left_Corner_Symbols, Sym) then
                  if Comma_Required then
                     Sparklalr_IO.Put_Line (F, ",");
                  else
                     Comma_Required := True;
                  end if;
                  Sparklalr_IO.Put_Int (F, Index, 5);
                  Sparklalr_IO.Put (F, " => ");
                  Pos := 10;
                  --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
                  Symbols_Dump.Print_String_Sym (F, Sparklalr_Common.Sp_Symbol_Str, Sym, Pos, 10, False);
                  --# end accept;
                  Index := Index + 1;
               end if;
            end loop;
            for Sym in Integer range Sparklalr_Common.Nt_Base + 1 .. Sparklalr_Common.Nt_Base + Symbols_Dump.Get_Nnon_Terms loop
               if Sparklalr_Memory.Get_Symbol_Set (Left_Corners (Nt).Left_Corner_Symbols, Sym) then
                  if Comma_Required then
                     Sparklalr_IO.Put_Line (F, ",");
                  else
                     Comma_Required := True;
                  end if;
                  Sparklalr_IO.Put_Int (F, Index, 5);
                  Sparklalr_IO.Put (F, " => ");
                  Pos := 10;
                  --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
                  Symbols_Dump.Print_String_Sym (F, Sparklalr_Common.Sp_Symbol_Str, Sym, Pos, 10, False);
                  --# end accept;
                  Index := Index + 1;
               end if;
            end loop;
         end if;
      end loop;
      Sparklalr_IO.Put_Line (F, ");");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   RelTab : constant RelationTable := RelationTable'(");
      if Command_Line_Options.Get_Self_Pack then
         for Nt in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms - 1 loop
            Sparklalr_Common.Put_N_Chars (F, ' ', 4);
            Pos := 4;
            --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
            Sparklalr_Common.Print2 (F, Sparklalr_Common.Sp_Symbol_Str, Symbols_Dump.Get_Nterm_Set (Nt), Pos, 4, False);
            --# end accept;
            Sparklalr_IO.Put (F, " => ");
            if Dump.Get_Terminal_Like (Nt + Sparklalr_Common.Nt_Base) then
               Sparklalr_IO.Put (F, "TerminalLike * Boolean'Pos (True) + ");
            else
               Sparklalr_IO.Put (F, "TerminalLike * Boolean'Pos (False) + ");
            end if;
            Sparklalr_IO.Put (F, "Low*");
            Sparklalr_IO.Put_Int (F, Left_Corners (Nt).Lower, 1);
            Sparklalr_IO.Put (F, " + ");
            Sparklalr_IO.Put (F, "High*");
            Sparklalr_IO.Put_Int (F, Left_Corners (Nt).Upper, 1);
            Sparklalr_IO.Put_Line (F, ",");
         end loop;
         Sparklalr_Common.Put_N_Chars (F, ' ', 4);
         Pos := 4;
         --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
         Sparklalr_Common.Print2
           (F,
            Sparklalr_Common.Sp_Symbol_Str,
            Symbols_Dump.Get_Nterm_Set (Symbols_Dump.Get_Nnon_Terms),
            Pos,
            4,
            False);
         --# end accept;
         Sparklalr_IO.Put (F, " => ");
         if Dump.Get_Terminal_Like (Symbols_Dump.Get_Nnon_Terms + Sparklalr_Common.Nt_Base) then
            Sparklalr_IO.Put (F, "TerminalLike * Boolean'Pos (True) + ");
         else
            Sparklalr_IO.Put (F, "TerminalLike * Boolean'Pos (False) + ");
         end if;
         Sparklalr_IO.Put (F, "Low*");
         Sparklalr_IO.Put_Int (F, Left_Corners (Symbols_Dump.Get_Nnon_Terms).Lower, 1);
         Sparklalr_IO.Put (F, " + ");
         Sparklalr_IO.Put (F, "High*");
         Sparklalr_IO.Put_Int (F, Left_Corners (Symbols_Dump.Get_Nnon_Terms).Upper, 1);
         Sparklalr_IO.Put_Line (F, ");");
      else
         for Nt in Integer range 1 .. Symbols_Dump.Get_Nnon_Terms - 1 loop
            Sparklalr_Common.Put_N_Chars (F, ' ', 4);
            Pos := 4;
            --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
            Sparklalr_Common.Print2 (F, Sparklalr_Common.Sp_Symbol_Str, Symbols_Dump.Get_Nterm_Set (Nt), Pos, 4, False);
            --# end accept;
            Sparklalr_IO.Put (F, " => RelationEntry'(");
            if Dump.Get_Terminal_Like (Nt + Sparklalr_Common.Nt_Base) then
               Sparklalr_IO.Put (F, "True, ");
            else
               Sparklalr_IO.Put (F, "False, ");
            end if;
            Sparklalr_IO.Put_Int (F, Left_Corners (Nt).Lower, 1);
            Sparklalr_IO.Put (F, ", ");
            Sparklalr_IO.Put_Int (F, Left_Corners (Nt).Upper, 1);
            Sparklalr_IO.Put_Line (F, "),");
         end loop;
         Sparklalr_Common.Put_N_Chars (F, ' ', 4);
         Pos := 4;
         --# accept F, 10, Pos, "Ineffective assignment here expected and OK";
         Sparklalr_Common.Print2
           (F,
            Sparklalr_Common.Sp_Symbol_Str,
            Symbols_Dump.Get_Nterm_Set (Symbols_Dump.Get_Nnon_Terms),
            Pos,
            4,
            False);
         --# end accept;
         Sparklalr_IO.Put (F, " => RelationEntry'(");
         if Dump.Get_Terminal_Like (Symbols_Dump.Get_Nnon_Terms + Sparklalr_Common.Nt_Base) then
            Sparklalr_IO.Put (F, "True, ");
         else
            Sparklalr_IO.Put (F, "False, ");
         end if;
         Sparklalr_IO.Put_Int (F, Left_Corners (Symbols_Dump.Get_Nnon_Terms).Lower, 1);
         Sparklalr_IO.Put (F, ", ");
         Sparklalr_IO.Put_Int (F, Left_Corners (Symbols_Dump.Get_Nnon_Terms).Upper, 1);
         Sparklalr_IO.Put_Line (F, "));");
      end if;
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "   function SPLeftCorner (Parent : SPSymbols.SPSymbol;");
      Sparklalr_IO.Put_Line (F, "                          Child : SPSymbols.SPSymbol) return Boolean is separate;");
      Sparklalr_IO.Put_Line (F, "   function SPTerminalLike (Sym : SPSymbols.SPSymbol) return Boolean is separate;");
      Sparklalr_IO.New_Line (F);
      Sparklalr_IO.Put_Line (F, "end SPRelations;");
   end Out_Left_Corner;

end Sparklalr_Memory.Left_Corner;
