-- $Id: sparklalr_level.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_Common;
with Sparklalr_Symbol;
--# inherit Sparklalr_Common,
--#         Sparklalr_Symbol;
package Sparklalr_Level
   --# own State;
is

   type Lev_Struct is private;

   procedure Initiate (L : out Lev_Struct);
   --# global in State;
   --# derives L from State;

   procedure Initialise;
   --# global out State;
   --# derives State from ;

   procedure Assign_Level (I : in Sparklalr_Common.Production_Index; M : in Lev_Struct);
   --# global in out State;
   --# derives State from *,
   --#                    I,
   --#                    M;

   procedure Assign_Term_Lev (I : in Sparklalr_Common.Term_Range; M : in Lev_Struct);
   --# global in out State;
   --# derives State from *,
   --#                    I,
   --#                    M;

   procedure Initiate_Level (I : in Sparklalr_Common.Production_Index);
   --# global in out State;
   --# derives State from *,
   --#                    I;

   procedure Initiate_Term_Lev (I : in Sparklalr_Common.Term_Range);
   --# global in out State;
   --# derives State from *,
   --#                    I;

   procedure Associativity (Symb : in Sparklalr_Symbol.Symbol; Current_Lev : in out Lev_Struct);
   --# derives Current_Lev from *,
   --#                          Symb;

   procedure Precedence
     (Is_Shred          : in Boolean;
      A, B              : in Integer;
      Term_Index        : in Integer;
      Report            : out Boolean;
      Result_Precedence : out Integer);
   --# global in State;
   --# derives Report,
   --#         Result_Precedence from A,
   --#                                B,
   --#                                Is_Shred,
   --#                                State,
   --#                                Term_Index;

   -- Getter
   function Get_Term_Lev (I : in Sparklalr_Common.Term_Range) return Lev_Struct;
   --# global in State;

   -- Setter
   procedure Set_Level_Action_Flag (I : in Sparklalr_Common.Production_Index; Value : in Boolean);
   --# global in out State;
   --# derives State from *,
   --#                    I,
   --#                    Value;

private

   type Assoc_T is (Leftass, Rightass, Nonass, Nodef);

   type Lev_Struct is record
      Assoc       : Assoc_T;
      Action_Flag : Boolean;
      Lev         : Sparklalr_Common.Short_Int;
   end record;

end Sparklalr_Level;
