-- $Id: sparklalr_io.ads 14467 2009-10-07 10:07:14Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Ada.Text_IO;

package Sparklalr_IO
   --# own Inputs  : Inputs_Type;
   --#     Outputs : Outputs_Type;
   --#     State   : State_Type;
   --# initializes Inputs,
   --#             Outputs,
   --#             State;
is
   --# type State_Type is abstract;
   --# type Inputs_Type is abstract;
   --# type Outputs_Type is abstract;

   Default_Width : constant Natural;
   Len_File_Name : constant := 5; -- length of a file name
   Len_File_Extn : constant := 4; -- length of a file extn (incl dot)

   type Typ_Exit is (Error, Warning, Ok);

   subtype Arg_String_Range is Positive range 1 .. 256;
   subtype File_Name_Range  is Positive range 1 .. Len_File_Name;
   subtype File_Extn_Range  is Positive range 1 .. Len_File_Extn;
   subtype File_Name is String (File_Name_Range);
   subtype File_Extn is String (File_Extn_Range);

   type File_Type is limited private;
   subtype Arg_String is String (Arg_String_Range);

   procedure Put_Char (Fil : in File_Type; C : in Character);
   --# global in out Outputs;
   --# derives Outputs from *,
   --#                      C,
   --#                      Fil;

   procedure Get_Char (Fil : in File_Type; C : out Character);
   --# global in out Inputs;
   --# derives C,
   --#         Inputs from Fil,
   --#                     Inputs;

   procedure Put_Int (Fil : in File_Type; I : in Integer; Width : in Natural);
   --# global in out Outputs;
   --# derives Outputs from *,
   --#                      Fil,
   --#                      I,
   --#                      Width;

   procedure Skip_Int (Fil : in File_Type; Width : in Natural);
   --# global in out Inputs;
   --# derives Inputs from *,
   --#                     Fil,
   --#                     Width;

   procedure Put (Fil : in File_Type; S : in String);
   --# global in out Outputs;
   --# derives Outputs from *,
   --#                      Fil,
   --#                      S;

   procedure Put_Line (Fil : in File_Type; S : in String);
   --# global in out Outputs;
   --# derives Outputs from *,
   --#                      Fil,
   --#                      S;

   procedure New_Line (Fil : in File_Type);
   --# global in out Outputs;
   --# derives Outputs from *,
   --#                      Fil;

   procedure Skip_Line (Fil : in File_Type; Spacing : in Positive);
   --# global in out Inputs;
   --# derives Inputs from *,
   --#                     Fil,
   --#                     Spacing;

   function End_Of_Line (Fil : in File_Type) return Boolean;
   --# global in Inputs;

   function End_Of_File (Fil : in File_Type) return Boolean;
   --# global in Inputs;

   procedure Look_Ahead (Fil : in File_Type; C : out Character);
   --# global in Inputs;
   --# derives C from Fil,
   --#                Inputs;

   function Argument_Count return Natural;
   --# global in State;

   function Argument (Number : in Positive) return Arg_String;
   --# global in State;

   procedure To_Upper (S : in out String);
   --# derives S from *;

   function Trim_Length (Arg : in Arg_String) return Natural;

   procedure Exit_St (S : in String; Status : in Typ_Exit);
   --# derives null from S,
   --#                   Status;
   --# post False; -- does not terminate normally

   procedure Rewrite
     (Fil         : out File_Type;
      Name        : in File_Name;
      Extn        : in File_Extn;
      File_Status : out Boolean);
   --# global in out State;
   --# derives Fil,
   --#         State       from Extn,
   --#                          Name,
   --#                          State &
   --#         File_Status from State;

   procedure Reset
     (Fil         : out File_Type;
      Name        : in File_Name;
      Extn        : in File_Extn;
      File_Status : out Boolean);
   --# global in out State;
   --# derives Fil,
   --#         State       from Extn,
   --#                          Name,
   --#                          State &
   --#         File_Status from State;

   function Standard_Output return File_Type;

private

   --# hide Sparklalr_IO;
   Default_Width : constant Natural := Integer'Width;

   type File_Type is record
      Ada_File_Type : Ada.Text_IO.File_Type;
   end record;

end Sparklalr_IO;
