-- $Id: sparklalr_input.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_IO;
with Sparklalr_Common;
with Sparklalr_Error;
with Sparklalr_Symbol;
use type Sparklalr_Symbol.Symbol;
--# inherit Command_Line_Options,
--#         Sparklalr_Char_Class,
--#         Sparklalr_Common,
--#         Sparklalr_Error,
--#         Sparklalr_IO,
--#         Sparklalr_Level,
--#         Sparklalr_Memory,
--#         Sparklalr_Symbol,
--#         Symbols_Dump;

package Sparklalr_Input
   --# own State;
is

   type Symbol_Set_Type is private;

   Symbol_Set_False_Const : constant Symbol_Set_Type;

   procedure Initialise (Signpost : out Symbol_Set_Type);
   --# global in     Command_Line_Options.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.State;
   --#           out Sparklalr_Char_Class.Charmap;
   --#           out Sparklalr_Error.State;
   --#           out Sparklalr_Level.State;
   --#           out State;
   --# derives Signpost,
   --#         Sparklalr_Char_Class.Charmap,
   --#         Sparklalr_Level.State        from  &
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs          from Command_Line_Options.State,
   --#                                           Sparklalr_IO.Inputs,
   --#                                           Sparklalr_IO.State &
   --#         Sparklalr_IO.State,
   --#         State                        from Command_Line_Options.State,
   --#                                           Sparklalr_IO.State;

   procedure Finalize (F : in Sparklalr_IO.File_Type);
   --# global in     Sparklalr_IO.Inputs;
   --#        in     State;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_Error.State from *,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    F,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State;

   function Signpost_To_Symbol_Set_Type (Signpost : in Symbol_Set_Type) return Symbol_Set_Type;

   procedure Scan
     (F     : in Sparklalr_IO.File_Type;
      Col   : in out Sparklalr_Error.Err_Col_T;
      Symb  : out Sparklalr_Symbol.Symbol;
      Token : out Sparklalr_Common.Id_Name);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Col,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs,
   --#         State,
   --#         Symb,
   --#         Token                 from Col,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    Col,
   --#                                    F,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State;

   procedure Skipto
     (F       : in Sparklalr_IO.File_Type;
      Arg_Set : in Symbol_Set_Type;
      Col     : in out Sparklalr_Error.Err_Col_T;
      Symb    : in out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Col,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs,
   --#         State,
   --#         Symb                  from Arg_Set,
   --#                                    Col,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symb &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    Arg_Set,
   --#                                    Col,
   --#                                    F,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symb;

   procedure Copy_Action
     (F, Echo  : in Sparklalr_IO.File_Type;
      Signpost : in Symbol_Set_Type;
      Col      : in out Sparklalr_Error.Err_Col_T;
      Symb     : in out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in     Sparklalr_Memory.Prod_No;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --# derives Col,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs,
   --#         State,
   --#         Symb                  from Col,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symb &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    Col,
   --#                                    Echo,
   --#                                    F,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    Sparklalr_Memory.Prod_No,
   --#                                    State,
   --#                                    Symb &
   --#         Sparklalr_Level.State from *,
   --#                                    Col,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    Sparklalr_Memory.Prod_No,
   --#                                    State,
   --#                                    Symb;

   procedure Skip_Action
     (F        : in Sparklalr_IO.File_Type;
      Signpost : in Symbol_Set_Type;
      Col      : in out Sparklalr_Error.Err_Col_T;
      Symb     : in out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out State;
   --# derives Col,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs,
   --#         State,
   --#         Symb                  from Col,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symb &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    Col,
   --#                                    F,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symb;

   procedure Proc_Term
     (F          : in Sparklalr_IO.File_Type;
      Gram_Rules : out Boolean;
      Col        : in out Sparklalr_Error.Err_Col_T;
      Signpost   : in Symbol_Set_Type;
      Symb       : out Sparklalr_Symbol.Symbol);
   --# global in     Sparklalr_Char_Class.Charmap;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_Level.State;
   --#        in out State;
   --#        in out Symbols_Dump.State;
   --# derives Col,
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs,
   --#         Sparklalr_Level.State,
   --#         State,
   --#         Symbols_Dump.State    from *,
   --#                                    Col,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symbols_Dump.State &
   --#         Gram_Rules            from  &
   --#         Sparklalr_IO.Outputs  from *,
   --#                                    Col,
   --#                                    F,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symbols_Dump.State &
   --#         Symb                  from Col,
   --#                                    Signpost,
   --#                                    Sparklalr_Char_Class.Charmap,
   --#                                    Sparklalr_Error.State,
   --#                                    Sparklalr_IO.Inputs,
   --#                                    State,
   --#                                    Symbols_Dump.State;

   -- Setter
   procedure Set_Symbol_Set (Symbol_Set : in out Symbol_Set_Type; Symb : in Sparklalr_Symbol.Symbol; Value : in Boolean);
   --# derives Symbol_Set from *,
   --#                         Symb,
   --#                         Value;

   -- Getter
   function Get_Symbol_Set (Symbol_Set : in Symbol_Set_Type; Symb : in Sparklalr_Symbol.Symbol) return Boolean;

private

   type Symbol_Set_Type is array (Sparklalr_Symbol.Symbol) of Boolean;

   Symbol_Set_False_Const : constant Symbol_Set_Type := Symbol_Set_Type'(others => False);

end Sparklalr_Input;
