-- $Id: sparklalr_common.ads 11998 2009-01-02 14:42:09Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with Sparklalr_IO;
--# inherit Sparklalr_IO;

package Sparklalr_Common is

   Id_Length   : constant := 50;
   Max_Set     : constant := 255; -- MAXIMUM ORDINAL IN SET
   Line_Length : constant := 120;
   State_Max   : constant := 2047; -- MAXIMUM STATE NUMBER
   Prod_Lim    : constant := 1023; -- MAXIMUM PRODUCTION NUMBER
   Page_Width  : constant := 78; -- Maximum width of output files

   Term_Lim     : constant := Max_Set; -- MAXIMUM TERMINAL NUMBER
   Non_Term_Lim : constant := 511; -- MAXIMUM NUMBER OF NON-TERMINALS
   Max_Sym      : constant := 766; -- = TERM_LIM + NON_TERM_LIM
   Nt_Base      : constant := Term_Lim; -- NON-TERMINAL OFFSET FOR PRDN. TABLE

   Sp_Symbol_Str : constant String := "SPSymbols.                                        ";

   type Action_Type is (Shift, Reduce);

   subtype Production_Count is Natural  range 0 .. Prod_Lim;
   subtype Production_Index is Positive range 1 .. Prod_Lim;

   subtype Id_Length_Count is Natural  range 0 .. Id_Length;
   subtype Id_Length_Range is Positive range 1 .. Id_Length;

   subtype Short_Int is Integer range -32767 .. 32767;
   subtype State_Range is Natural range 0 .. State_Max;
   subtype Id_Name is String (Id_Length_Range);

   subtype Term_Range is Natural range 0 .. Term_Lim;
   subtype Non_Term_Range is Positive range 1 .. Non_Term_Lim;
   subtype Sym_Range is Integer range -1 .. Max_Sym;

   -- Puts C to Fil N times.  N can be zero.
   procedure Put_N_Chars (Fil : in Sparklalr_IO.File_Type; C : in Character; N : in Natural);
   --# global in out Sparklalr_IO.Outputs;
   --# derives Sparklalr_IO.Outputs from *,
   --#                                   C,
   --#                                   Fil,
   --#                                   N;

   procedure Print
     (F       : in Sparklalr_IO.File_Type;
      String1 : in String;
      Posn    : in out Integer;
      Tab     : in Integer;
      Comm    : in Boolean);
   --# global in out Sparklalr_IO.Outputs;
   --# derives Posn                 from *,
   --#                                   String1,
   --#                                   Tab &
   --#         Sparklalr_IO.Outputs from *,
   --#                                   Comm,
   --#                                   F,
   --#                                   Posn,
   --#                                   String1,
   --#                                   Tab;

   procedure Print2
     (F       : in Sparklalr_IO.File_Type;
      String1 : in String;
      String2 : in String;
      Posn    : in out Integer;
      Tab     : in Integer;
      Comm    : in Boolean);
   --# global in out Sparklalr_IO.Outputs;
   --# derives Posn                 from *,
   --#                                   String1,
   --#                                   String2,
   --#                                   Tab &
   --#         Sparklalr_IO.Outputs from *,
   --#                                   Comm,
   --#                                   F,
   --#                                   Posn,
   --#                                   String1,
   --#                                   String2,
   --#                                   Tab;

   function Code (Sr : in Action_Type; C : in Integer) return Integer;

   function Decode (C : in Integer) return Integer;

end Sparklalr_Common;
