-- $Id: sparkformatmain.adb 16523 2010-03-23 10:17:24Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with CommandLineData,
  Dictionary,
  ErrorHandler,
  EStrings,
  SPARK_IO,
  SparkFormatCommandLineData,
  SparkFormatCommandLineHandler,
  SparkLex,
  SPARKProgram,
  Version;
use type SPARK_IO.File_Status;
--# inherit CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         LexTokenManager,
--#         SparkFormatCommandLineData,
--#         SparkFormatCommandLineHandler,
--#         SparkLex,
--#         SPARKProgram,
--#         SPARK_IO,
--#         Statistics,
--#         Version;

--# main_program
procedure SPARKFormatMain
--# global in out ErrorHandler.ErrorContext;
--#        in out LexTokenManager.State;
--#        in out SPARK_IO.File_Sys;
--#        in out Statistics.TableUsage;
--#           out CommandLineData.Content;
--#           out Dictionary.Dict;
--#           out SparkFormatCommandLineData.Content;
--#           out SparkLex.CurrLine;
--# derives CommandLineData.Content,
--#         Dictionary.Dict,
--#         SparkFormatCommandLineData.Content from LexTokenManager.State,
--#                                                 SPARK_IO.File_Sys &
--#         ErrorHandler.ErrorContext,
--#         LexTokenManager.State,
--#         SPARK_IO.File_Sys,
--#         Statistics.TableUsage              from *,
--#                                                 ErrorHandler.ErrorContext,
--#                                                 LexTokenManager.State,
--#                                                 SPARK_IO.File_Sys &
--#         SparkLex.CurrLine                  from ErrorHandler.ErrorContext,
--#                                                 LexTokenManager.State,
--#                                                 SPARK_IO.File_Sys;
is
   Input         : SPARK_IO.File_Type;
   Output        : SPARK_IO.File_Type;
   TemporaryFile : SPARK_IO.File_Type;
   Status        : SPARK_IO.File_Status;
   FileName      : EStrings.T;

   procedure PrintHelp
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *;
   --
   -- Outputs the usage to the user.
   is
      --# hide PrintHelp;
   begin
      --  Exclude is a hidden option do not include it in help text.
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "Usage: sparkformat {option} [argument-list]",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "Options - all may be abbreviated to the shortest unique prefix",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "option = modes_option | indent_option | defaultfunction_option | help_option |",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                           "         annotation_option | expansion_option | order_option | noswitch_option",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "modes_option = add_modes_option | noadd_modes_option",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  add_modes_option = " &
                           "-" &
                           "add_modes      - add modes to unmoded global variables.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                     - Default: off",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  noadd_modes_option = " &
                           "-" &
                           "noadd_modes  -  do not add modes to unmoded global",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                     variables.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                     - Default: on",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "indent_option = export_option | import_option | global_option",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "              | inherit_option | own_option | refinement_option",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "              | constituent_option | initialization_option",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "              | separator_option | properties_option",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  export_option = " &
                           "-" &
                         "export_indent       - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the export variables from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                        them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  import_option = " &
                           "-" &
                         "import_indent       - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the import variables from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  global_option = " &
                           "-" &
                         "global_indent       - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the global variables from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  inherit_option = " &
                           "-" &
                         "inherit_indent      - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the package names from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  own_option = " &
                           "-" &
                         "own_indent          - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the own variables from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  refinement_option = " &
                           "-" &
                         "refinement_indent",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the own variables from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  constituent_option = " &
                           "-" &
                         "constituent_indent",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the constituents from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  initialization_option = " &
                           "-" &
                         "initialization_indent",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the own variables from --# or keeps ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  separator_option = " &
                           "-" &
                         "separator_indent - specifies the degree of indentation of",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       the separators from and & from --# or ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       keeps them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  properties_option = " &
                           "-" &
                         "properties_indent - specifies the degree of indentation",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       of own variable properties from --# or ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       keeps them inline.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                       - Default: inline",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "defaultfunction_option = " &
                           "-" &
                           "default_function_modes = in_mode | unmoded  ",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                       - when used in conjunction with /add_modes, force ",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                       global variables of functions to the specified ",
                               0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                       default function mode. ",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                       - Default: unmoded",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
            SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "help_option = help_option | version_option",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  help_option = " &
                           "-" &
                           "help       - print off help information.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  version_option = " &
                           "-" &
                           "version - print off version information.",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "annotation_option = " &
                           "-" &
                           "annotation_character - specify annotation character.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                                          - Default: #",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "expansion_option = expand_option | compress_option",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  expand_option = " &
                           "-" &
                           "expand     - expands the dependency relations.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                              - Default: off",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "  compress_option = " &
                           "-" &
                           "compress - compresses the dependency relations.",
                         0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "                              - Default: on",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "noswitch_option = -noswitch   - ignore spark.sw file",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);


      SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
                         "argument-list = file-spec { separator file-spec } - File(s) to reformat",
                         0);
      SPARK_IO.New_Line (SPARK_IO.Standard_Output, 1);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Version.Toolset_Support_Line1, 0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Version.Toolset_Support_Line2, 0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Version.Toolset_Support_Line3, 0);
      SPARK_IO.Put_Line (SPARK_IO.Standard_Output, Version.Toolset_Support_Line4, 0);
   end PrintHelp;

   procedure PrintVersion
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *;
   --
   -- Outputs the usage to the user.
   is
      --# hide PrintVersion;
   begin

      SPARK_IO.Put_Line
        (SPARK_IO.Standard_Output,
         "SPARKFormat " & Version.Toolset_Banner_Line, 0);
      SPARK_IO.Put_Line
        (SPARK_IO.Standard_Output,
         Version.Toolset_Copyright, 0);
   end PrintVersion;

begin

   CommandLineData.Initialize;

   --# accept w, 169, CommandLineData.Content.LanguageProfile, "Direct update OK here.";
   CommandLineData.Content.LanguageProfile := CommandLineData.SPARK95; -- Allow SPARK95 mode
   --# end accept;

   -- Always allow FDL reserved words as identifiers. Leave it to the Examiner
   -- to reject them later if required.
   --# accept w, 169, CommandLineData.Content.FDLreserved, "Direct update OK here.";
   CommandLineData.Content.FDLreserved := False;
   --# end accept;

   Dictionary.Initialize (WriteToFile => False);

   SparkFormatCommandLineData.Initialize;
   SparkFormatCommandLineHandler.Process;
   ErrorHandler.SparkMakeInit;
   SparkLex.ClearLineContext;

   --  if EStrings.IsEmpty (SparkFormatCommandLineData.Content.ExcludeExport) then
   --     SPARK_IO.Put_Line (SPARK_IO.Standard_Output,
   --                        "No Exclude Export Specified",
   --                        0);
   --  else
   --     SPARK_IO.Put_String (SPARK_IO.Standard_Output,
   --                      "Exclude Export:",
   --                      0);
   --     EStrings.PutLine (SPARK_IO.Standard_Output,
   --                            SparkFormatCommandLineData.Content.ExcludeExport);
   --  end if;

   if SparkFormatCommandLineData.Content.Valid then

      if SparkFormatCommandLineData.Content.Help then

         PrintHelp;

      elsif SparkFormatCommandLineData.Content.Version then

         PrintVersion;

      elsif SparkFormatCommandLineData.Content.NumberSource > 0 then

         for SourceFile in SparkFormatCommandLineData.SourceFileCounts
           range 1 .. SparkFormatCommandLineData.Content.NumberSource loop

            FileName := SparkFormatCommandLineData.Content.SourceFileList (SourceFile).SourceFileName;
            Input := SPARK_IO.Null_File;
            EStrings.Open (File         => Input,
                           Mode_Of_File => SPARK_IO.In_File,
                           Name_Of_File => FileName,
                           Form_Of_File => "",
                           Status       => Status);
            if Status /= SPARK_IO.Ok then
               SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Can't open ", 0);
               EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                                  E_Str => FileName);
            else
               TemporaryFile := SPARK_IO.Null_File;

               --# accept Flow_Message, 10, Status, "Status is ignored";
               SPARK_IO.Create (TemporaryFile, 0, "", "", Status);
               -- don't know what we can do if we can't create the temporary file
               --# end accept;

               SPARKProgram.ReformatAnnotations (Input, TemporaryFile);

               --# accept Flow_Message, 10, Status, "Status is ignored" &
               --#        Flow_Message, 10, Input, "File 'Input'  is closed";
               SPARK_IO.Close (Input, Status);
               -- don't know what we can do if we can't close the input file
               --# end accept;

               --# accept Flow_Message, 10, Status, "Status is ignored";
               SPARK_IO.Reset (TemporaryFile,
                               SPARK_IO.In_File,
                               Status);
               -- don't know what we can do if we can't reset the temporary file
               --# end accept;

               Output := SPARK_IO.Null_File;
               EStrings.Create (File         => Output,
                                Name_Of_File => SparkFormatCommandLineData.Content.SourceFileList (SourceFile).SourceFileName,
                                Form_Of_File => "",
                                Status       => Status);
               if Status /= SPARK_IO.Ok then
                  SPARK_IO.Put_String (SPARK_IO.Standard_Output, "Can't write to ", 0);
                  EStrings.Put_Line (File  => SPARK_IO.Standard_Output,
                                     E_Str => FileName);
               else
                  SPARKProgram.Copy (TemporaryFile, Output);
               end if;
            end if;

         end loop;

      else
         SPARKProgram.ReformatAnnotations (SPARK_IO.Standard_Input, SPARK_IO.Standard_Output);
      end if;

   end if;

end SPARKFormatMain;
