-- $Id: sparkformatcommandlinedata.adb 15795 2010-01-26 14:30:59Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


package body SparkFormatCommandLineData
is

   Ada_Extension : constant String := "ada";

   procedure Initialize
   is
   begin
      Content := CommandLineContents'
         (Valid               => True,
          SourceExtension     => EStrings.Copy_String (Str => Ada_Extension),
          ExcludeExport       => EStrings.Empty_String,
          NumberSource        => 0,
          SourceFileList      =>
            SourceFileLists'(others => SourceFileEntry'
                               (SourceFileName => EStrings.Empty_String)),
         Operation            => Compress,
         AddModes             => False,
         GlobalIndent         => Inline,
         ExportIndent         => Inline,
         ImportIndent         => Inline,
         InheritIndent        => Inline,
         OwnIndent            => Inline,
         RefinementIndent     => Inline,
         ConstituentIndent    => Inline,
         InitializationIndent => Inline,
         SeparatorIndent      => Inline,
         PropertiesIndent     => Inline,
         Help                 => False,
         Version              => False,
         DefaultFunctionMode  => Unmoded);
   end Initialize;

end SparkFormatCommandLineData;
