%  $Id: simplifier.pro 16577 2010-03-26 11:47:17Z dean kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Top level file, to build the Simplifier without flexlm.
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################


%###############################################################################
% DEPENDENCIES
%###############################################################################

%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################


%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% LOAD ENHANCED DEFECT REPORTING
%===============================================================================
:- use_module('defectreporting.pro').
%===============================================================================

%===============================================================================
% LOAD SICSTUS LIBRARIES BEFORE DYNAMIC CHANGES
%===============================================================================
:- use_module('librarypredicates.pro').

:- load_files(library(system), [when(compile_time), imports([environ/2])]).

%===============================================================================

%===============================================================================
% DYNAMIC FEATURES PRE-LOAD
%===============================================================================
:- use_module('settings.pro',
              [declare_settings/0]).
:- declare_settings.

:- use_module('opdeclar.pro',
              [declare_operators/0,
               hide_operators/0]).
:- declare_operators.

% Conditional compilation - only compile usage utilities is the user
% has installed TCLTK libraries and wants usage profiling.

:- if(environ('USAGE_PROFILING', 'ON')).

:- use_module('usage_utilities.pro',
              [save_usage_data/0,
               view_usage/0]).
:- endif.

%===============================================================================

%===============================================================================
% FIXED SYSTEM CONFIGURATION
%-------------------------------------------------------------------------------
% This information will be the same for every execution of the tool.
%===============================================================================
:- use_module('data__system.pro',
              [add_system_toolname/1]).

:- use_module('load__switches.pro').

%===============================================================================

%===============================================================================
% LOAD SYSTEM
%===============================================================================
:- include('main_simplifier.pro').
%===============================================================================

%===============================================================================
% runtime_entry(start).
%-------------------------------------------------------------------------------
% This is a special Sicstus predicate, which will be automatically invoked
% when restoring a saved state. It is the top level, or main, predicate.
%===============================================================================

runtime_entry(start):-
    simplifier_main,
    save_usage_profile,
    close_all_streams,
    halt(0),
    !.

%===============================================================================
% save_usage_profile
%-------------------------------------------------------------------------------
% Predicate to save usage data if usage switch specifies a file.
% Usage is only possible when the Simplifier is compiled using the
% prolog flag profiledcode (refer to makefile) and when it is run in
% Sicstus interactive mode (limitation of Sicstus) - see usage_profile script.
%===============================================================================

:- if(environ('USAGE_PROFILING', 'ON')).

save_usage_profile:-
    \+ get_switch_usage(no_usage_file),
    save_usage_data,
    !.

:- endif.

save_usage_profile:-
    !.

%===============================================================================
% show_usage
%-------------------------------------------------------------------------------
% Show collected usage data.
%===============================================================================

:- if(environ('USAGE_PROFILING', 'ON')).

show_usage:-
    load_switches,
    view_usage,
    halt(0).

:- endif.

%===============================================================================

%===============================================================================
% DYNAMIC FEATURES POST-LOAD
%===============================================================================

% _After_ all dynamic predicates have been introduced, we need to disable
% "dynamic" as an operator in case a user has an fdl entity called
% "dynamic". Same goes for the other predefined prolog operators that might
% look like fdl identifiers. See the sicstus manual section "Standard
% Operators"
:- hide_operators.
%===============================================================================

%===============================================================================
% BUILD SAV AND HALT
%===============================================================================

buildsav_simplifier:-
    zero_defects_reported,
    save_program('spadesimp.sav'),
    close_all_streams,
    halt(0).

buildsav_simplifier:-
    report_total_defects,
    close_all_streams,
    halt(1).

buildsav_zombiescope:-
    zero_defects_reported,
    save_program('zombiescope.sav'),
    close_all_streams,
    halt(0).

buildsav_zombiescope:-
    report_total_defects,
    close_all_streams,
    halt(1).

buildsav_usage_profiled:-
    zero_defects_reported,
    save_program('spadesimp_usage_profiled.sav'),
    halt(0).

buildsav_usage_profiled:-
    report_total_defects,
    halt(1).

%===============================================================================

%###############################################################################
% END-OF-FILE
