%  $Id: settings.pro 12703 2009-03-12 16:38:35Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Declare the global prolog settings for the whole session. These settings
% should be activated early in the system build.
%###############################################################################

%###############################################################################
%MODULE
%###############################################################################
:- module(settings, [declare_settings/0]).

%###############################################################################
%DEPENDENCIES
%###############################################################################

%###############################################################################
%TYPES
%###############################################################################

%###############################################################################
%DYNAMICS
%###############################################################################

%###############################################################################
%PREDICATES
%###############################################################################

%===============================================================================
%declare_settings.
%-------------------------------------------------------------------------------
% Declare global prolog settings for the session.
%===============================================================================

declare_settings:-







    %Report single variables.
    set_prolog_flag(single_var_warnings, on),

    %Report discontiguous predicates.
    set_prolog_flag(discontiguous_warnings, on),

    %Report redefined predicates.
    set_prolog_flag(redefine_warnings, on),

    %Report calling of undefined predicates.
    set_prolog_flag(unknown, error),

    %Report syntax errors.
    set_prolog_flag(syntax_errors, error),
    !.

%###############################################################################
%END-OF-FILE
