%  $Id: processrules.pro 13327 2009-05-22 10:22:27Z Dean Kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Provides support for processing rules after they have been loaded.
%###############################################################################

%###############################################################################
%MODULE
%###############################################################################

:- module(processrules, [do_rule_substitutions0/0]).

:- use_module('data__rules.pro').

:- use_module('newutilities.pro').

%###############################################################################
%DEPENDENCIES
%###############################################################################

%###############################################################################
%TYPES
%###############################################################################

%###############################################################################
%DATA
%###############################################################################

%###############################################################################
%PREDICATES
%###############################################################################

%===============================================================================
%do_rule_substitutions0.
%-------------------------------------------------------------------------------
% Seeks to apply the loaded rules to transform the loaded rules. The aim
% here is to eliminate constants in the rules up-front, to reduce the
% number of rule applications seen in rewriting the vcs.
%===============================================================================










do_rule_substitutions0 :-
        scalar_replacement_rule(Name, X, Y),
        apply_rule_to_existing_rules(Name, X, Y).
do_rule_substitutions0 :- !.

%-------------------------------------------------------------------------------

scalar_replacement_rule(Name, X, Y) :-
    replace_rule(Name, X, Y),
    atom(X),
    user:int_enum_lit_or_const(Y, _T).

%-------------------------------------------------------------------------------





apply_rule_to_existing_rules(ApplyRuleName_Atom, ApplyLHS_Exp, ApplyRHS_Exp) :-
    get_rule(TargetRuleFile_Atom,
             TargetRuleName_Atom,
             RuleSource,
             Target_RuleHeuristic,
             Target_RuleLogic,
             TargetLHS_ExpList,
             TargetRHS_ExpList,
             TargetCondition_ExpList),

    /* prevent self-application */
    TargetRuleName_Atom\= ApplyRuleName_Atom,
    user:subst_vbl_list(ApplyLHS_Exp, ApplyRHS_Exp, TargetLHS_ExpList, NewTargetLHS_ExpList),
    user:subst_vbl_list(ApplyLHS_Exp, ApplyRHS_Exp, TargetRHS_ExpList, NewTargetRHS_ExpList),
    user:subst_vbl_list(ApplyLHS_Exp, ApplyRHS_Exp, TargetCondition_ExpList, NewTargetCondition_ExpList),

   /* so they do differ */
    \+ (TargetLHS_ExpList == NewTargetLHS_ExpList,
        TargetRHS_ExpList == NewTargetRHS_ExpList,
        TargetCondition_ExpList == NewTargetCondition_ExpList),





    prune_rule(TargetRuleFile_Atom,
             TargetRuleName_Atom,
             RuleSource,
             Target_RuleHeuristic,
             Target_RuleLogic,
             TargetLHS_ExpList,
             TargetRHS_ExpList,
             TargetCondition_ExpList),

    add_rule(TargetRuleFile_Atom,
             TargetRuleName_Atom,
             RuleSource,
             Target_RuleHeuristic,
             Target_RuleLogic,
             NewTargetLHS_ExpList,
             NewTargetRHS_ExpList,
             NewTargetCondition_ExpList),
    fail.

%###############################################################################
%END-OF-FILE
