%  $Id: defectreporting.pro 13494 2009-06-15 14:43:45Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Support file to offer improved reporting of warnings and errors detected
% at compilation.
%###############################################################################

%###############################################################################
% MODULE
%###############################################################################

%###############################################################################
% DEPENDENCIES
%###############################################################################

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

:- dynamic(defect_counter/1).
:- assert(defect_counter(0)).

%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% message_hook(+Severity, +Message, +Lines).
%-------------------------------------------------------------------------------
% Provide an alternative implementation for the message_hook. This enables
% us abort with an error code, preventing compilation, if any defects are
% detected. Further, it also supports slightly cleaner defect reports, to
% assist in debugging.
%===============================================================================

% Report errors and warnings, and count these as defects.
message_hook(Severity, _Message, Lines):-
    member(Severity,[error, warning]),
    increase_defect_counter,

    % Present defect message, preceded by separating blank line.
    nl(user_error),
    print_message_lines(user_error, Severity, Lines), flush_output,
    !.

% Report all other messages, but do not separate these with blank lines nor
% count these as defects.
message_hook(Severity, _Message, Lines):-
    print_message_lines(user_error, Severity, Lines), flush_output,
    !.

%-------------------------------------------------------------------------------

increase_defect_counter:-
    retract(defect_counter(At_Int)),
    Next_Int is At_Int+1,
    assert(defect_counter(Next_Int)),
    !.
%===============================================================================

%===============================================================================
% zero_defects_reported.
%-------------------------------------------------------------------------------
% Succeeds where zero defects have been reported.
%===============================================================================
zero_defects_reported:-
    defect_counter(0),
    !.
%===============================================================================

%===============================================================================
% report_total_defects.
%-------------------------------------------------------------------------------
% Report the total number of defects reported.
%===============================================================================

report_total_defects:-
    defect_counter(At_Int),
    nl,
    write(At_Int),
    write(' defects detected.'), nl,
    nl,
    !.
%===============================================================================

%###############################################################################
% END-OF-FILE
