%  $Id: data__subst_hyp.pro 13345 2009-05-28 15:05:13Z Dean Kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Manage (store, retreive and delete) database for 'substituted hypothesises'.
%###############################################################################

%###############################################################################
% MODULE
%###############################################################################

:- module(data__subst_hyp, [add_subst_hyp/3,
                            get_subst_hyp/3,
                            prune_all_subst_hyp/3]).

%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('data__formats.pro',
              [add_state/2,
               add_type/2]).

:- use_module('data__hyp.pro',
              [get_hyp/3]).

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

:- add_state(get_subst_hyp,
             get_hyp('Hypothesis_Term', 'HypothesisType', 'Id_Int')).

:- dynamic(get_subst_hyp/3).

%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% add_subst_hyp(+Hyp_Term, +HypType, +Id_Int)
%
% Insert into the subst_hyp database if it is not a hypothesis and not already
% in the database.
%===============================================================================

add_subst_hyp(Hyp_Term, HypType, Id_Int):-
    get_hyp(Hyp_Term, HypType, Id_Int),
    !.

add_subst_hyp(Hyp_Term, HypType, Id_Int):-
    get_subst_hyp(Hyp_Term, HypType, Id_Int),
    !.

add_subst_hyp(Hyp_Term, HypType, Id_Int):-
    assertz(get_subst_hyp(Hyp_Term, HypType, Id_Int)),
    !.

%===============================================================================

%===============================================================================
% prune_all_proved_concs
%
% Delete all proved conclusions from the database.
%===============================================================================

prune_all_subst_hyp(Hyp_Term, HypType, Id_Int):-
    retractall(get_subst_hyp(Hyp_Term, HypType, Id_Int)).

%===============================================================================

%###############################################################################
% END-OF-FILE
