%  $Id: data__proved_conc.pro 13345 2009-05-28 15:05:13Z Dean Kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================

%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Manage (store, retreive and delete) database for 'proved conclusions'.
%###############################################################################

%###############################################################################
% MODULE
%###############################################################################

:- module(data__proved_conc, [add_proved_conc/1,
                              get_proved_conc/1,
                              prune_proved_conc/1,
                              prune_all_proved_concs/0]).

%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('data__formats.pro',
              [add_state/2,
               add_type/2]).

%###############################################################################
% TYPES
%###############################################################################

%###############################################################################
% DATA
%###############################################################################

:- add_state(get_proved_conc,
             get_proved_conc('Id_Int')).

:- dynamic(get_proved_conc/1).

%###############################################################################
% PREDICATES
%###############################################################################

%===============================================================================
% add_proved_conc(+Id_Int)
%
% Insert the proved conclusion Id_Int into the database.

%===============================================================================

add_proved_conc(Id_Int):-
    assertz(get_proved_conc(Id_Int)).

%===============================================================================

%===============================================================================
% prune_proved_conc(+Id_Int)
%
% Delete Id_Int from the database.
%===============================================================================

prune_proved_conc(Id_Int):-
    retract(get_proved_conc(Id_Int)).

%===============================================================================

%===============================================================================
% prune_all_proved_concs
%
% Delete all proved conclusions from the database.
%===============================================================================

prune_all_proved_concs:-
    retractall(get_proved_conc(_)).

%===============================================================================

%###############################################################################
% END-OF-FILE
