%  $Id: data__pfs.pro 13342 2009-05-28 14:20:05Z Dean Kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Provides access to all information related to pfs. This information will
% be retrieved from the provided pfs file.
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################

:- module(data__pfs, [get_pfs_statement/2,
                      add_pfs_statement/2,
                      get_pfs_successor_statement/3,
                      add_pfs_successor_statement/3,
                      get_pfs_pf/4,
                      add_pfs_pf/4,
                      get_pfs_traversal_condition/3,
                      add_pfs_traversal_condition/3,
                      get_pfs_action/2,
                      add_pfs_action/2,

                      save_data__pfs/0]).


%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('data__formats.pro', [add_state/2,
                                 add_type/2]).
:- use_module('ioutilities.pro', [write_terms_to_file/2]).
:- use_module('data__data_files.pro', [must_get_datafiles_debug/2]).


%###############################################################################
% TYPES
%###############################################################################

% Statement: start      2 successor(s)
% Statement: line 48     2 successor(s)
:- add_type('PFTraceStatement',
            [statement('PFPositionFrom', 'Successors_Int')]).

:- add_type('PFPositionFrom',
            [start,
             line('Int')]).

% Successor statement: line 32.
% Successor statement:  finish.
:- add_type('PFTraceSuccessorStatement',
            [successor_statement('PFPositionTo')]).

:- add_type('PFPositionTo',
            [finish,
             line('Int')]).


%###############################################################################
% DATA
%###############################################################################

% A pfs file has a number of statement lines.
% Each statement has a number of successors.
% Each successor has a number of path functions.
% Each path function has a number of traversal conditions and an action.

:- add_state(get_pfs_statement,
             get_pfs_statement('StatementId_Atom', 'PFTraceStatement')).
:- dynamic(get_pfs_statement/2).

:- add_state(get_pfs_successor_statement,
             get_pfs_successor_statement('SuccessorStatementId_Atom',
                                         'PFTraceSuccessorStatement',
                                         'ParentStatementId_Atom')).
:- dynamic(get_pfs_successor_statement/3).

:- add_state(get_pfs_pf,
             get_pfs_pf('PFId_Atom',
                        'Order_Int',
                        'Number_Int',
                        'ParentSuccessorStatementId_Atom')).
:- dynamic(get_pfs_pf/4).

:- add_state(get_pfs_traversal_condition,
             get_pfs_traversal_condition('Number_Int', 'TravCond_Term', 'ParentPFId_Atom')).
:- dynamic(get_pfs_traversal_condition/3).

:- add_state(get_pfs_action,
             get_pfs_action('Action_Term', 'ParentPFId_Atom')).
:- dynamic(get_pfs_action/2).


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% Add.
%===============================================================================

add_pfs_statement(StatementId_Atom, PFTraceStatement):-
    assert(get_pfs_statement(StatementId_Atom, PFTraceStatement)),
    !.

add_pfs_successor_statement(SuccessorStatementId_Atom,
                            PFTraceSuccessorStatement,
                            ParentStatementId_Atom):-
    assert(get_pfs_successor_statement(SuccessorStatementId_Atom,
                                       PFTraceSuccessorStatement,
                                       ParentStatementId_Atom)),
    !.

add_pfs_pf(PFId_Atom,
           Order_Int,
           Number_Int,
           ParentSuccessorStatementId_Atom):-
    assert(get_pfs_pf(PFId_Atom,
                      Order_Int,
                      Number_Int,
                      ParentSuccessorStatementId_Atom)),
    !.

add_pfs_traversal_condition(Number_Int, TravCond_Term, ParentPFId_Atom):-
    assert(get_pfs_traversal_condition(Number_Int, TravCond_Term, ParentPFId_Atom)),
    !.

add_pfs_action(Action_Term, ParentPFId_Atom):-
    assert(get_pfs_action(Action_Term, ParentPFId_Atom)),
    !.
%===============================================================================


%===============================================================================
% save_data_prf.
%===============================================================================

save_data__prf:-
    must_get_datafiles_debug(data__pfs, DebugFile_Atom),
    write_terms_to_file(DebugFile_Atom,
                        [data__pfs:get_pfs_statement/2,
                         data__pfs:get_pfs_successor_statement/3,
                         data__pfs:get_pfs_pf/4,
                         data__pfs:get_pfs_traversal_condition/3,
                         data__pfs:get_pfs_action/2]),
    !.
%===============================================================================


%###############################################################################
% END-OF-FILE
