-- $Id: vcs-processnewrangeline.adb 14621 2009-10-28 13:48:23Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Procedure to process type (1) lines for the VCS package                     --
--                                                                            --
--------------------------------------------------------------------------------
with VCDetails;

separate (VCS)
procedure ProcessNewRangeLine
  (Line   : in     EStrings.T;
   VCInfo : in out VCInfoType)
is
   NewEndLine          : VCLineType;
   NewStartLine        : VCLineType;
   NewVCInfo           : VCInfoType;
   NewEndLinePointType : VCDetails.TerminalPointType;

   ---------------------------------------------------------------------
   -- The first line specified in a line of type (1) is found as follows:
   -- If the line contains 'start' then that's it
   -- If the line contatin 'refinement' then that's it
   -- If the line contatin 'inheritance' then that's it
   -- otherwise find the first occurrence of 'line' and extract the number
   -- which follows
   function ExtractFirstLineInRange (Line : EStrings.T)
                                    return VCLineType
   is
      DummyPosition    : EStrings.Positions;
      LineFound        : Boolean;
      LinePosition     : EStrings.Positions;
      LineNumber       : VCLineType;
      StartFound       : Boolean;
      RefinementFound  : Boolean;
      InheritanceFound : Boolean;
   begin -- ExtractFirstLineInRange

      --# accept F, 10, DummyPosition, "DummyPosition unused here";
      EStrings.Find_Sub_String (E_Str         => Line,
                                Search_String => "inheritance",
                                String_Found  => InheritanceFound,
                                String_Start  => DummyPosition);

      EStrings.Find_Sub_String (E_Str         => Line,
                                Search_String => "refinement",
                                String_Found  => RefinementFound,
                                String_Start  => DummyPosition);

      EStrings.Find_Sub_String (E_Str         => Line,
                                Search_String => "start",
                                String_Found  => StartFound,
                                String_Start  => DummyPosition);
      --# end accept;

      if RefinementFound or InheritanceFound then
         LineNumber := Refinement_Or_Inheritance_VC;
      elsif StartFound then
         LineNumber := VCLineStart;
      else
         --# accept F, 10, LineFound, "LineFound unused here";
         EStrings.Find_Sub_String (E_Str         => Line,
                                   Search_String => "line",
                                   String_Found  => LineFound,
                                   String_Start  => LinePosition);
         --# end accept;
         LineNumber := ExtractLineNumberAtPosition (Line, LinePosition + 5);
      end if;

      --# accept F, 33, DummyPosition, "DummyPosition unused here" &
      --#        F, 33, LineFound, "LineFound unused here";
      return LineNumber;
   end ExtractFirstLineInRange;

   ---------------------------------------------------------------------
   -- the second line specified in a line of type (1) is found as follows:
   -- either find "finish", or find first occurrence of "line" after "start"
   -- or find second occurrence of "line"

   function ExtractLastLineInRange (Line : EStrings.T)
      return VCLineType
   is
      DummyPosition : EStrings.Positions;
      FinishFound   : Boolean;
      LineFound     : Boolean;
      LinePosition  : EStrings.Positions;
      LineNumber    : VCLineType;
      FirstLinePos  : EStrings.Positions;

      ---------------------------------------------------------------------
      -- this function returns the index of the string "start" in the line
      -- if this is not present, it returns the index of the first occurrence
      -- of "line"
      -- the action if neither is present is undefined
      function PositionOfFirstLineNumber
        (Line : EStrings.T)
        return EStrings.Positions
      is
         LineFound     : Boolean;
         LinePosition  : EStrings.Positions;
         Pos           : EStrings.Positions;
         StartFound    : Boolean;
         StartPosition : EStrings.Positions;

      begin -- PositionOfFirstLineNumber
         EStrings.Find_Sub_String (E_Str         => Line,
                                   Search_String => "start",
                                   String_Found  => StartFound,
                                   String_Start  => StartPosition);
         if StartFound then
            Pos := StartPosition;
         else
            --# accept F, 10, LineFound, "LineFound unused here";
            EStrings.Find_Sub_String (E_Str         => Line,
                                      Search_String => "line",
                                      String_Found  => LineFound,
                                      String_Start  => LinePosition);
            --# end accept;
            Pos := LinePosition;
         end if;

         --# accept F, 33, LineFound, "LineFound unused here";
         return Pos;
      end PositionOfFirstLineNumber;

      ---------------------------------------------------------------------
   begin -- ExtractLastLineInRange
      --# accept F, 10, DummyPosition, "DummyPosition unused here";
      EStrings.Find_Sub_String (E_Str         => Line,
                                Search_String => "finish",
                                String_Found  => FinishFound,
                                String_Start  => DummyPosition);
      --# end accept;
      if FinishFound then
         LineNumber := VCLineEnd;
      else

         -- find first line number
         FirstLinePos := PositionOfFirstLineNumber (Line);

         -- skip it and find second one
         --# accept F, 10, LineFound, "LineFound unused here";
         EStrings.Find_Sub_String_After (E_Str         => Line,
                                         Search_Start  => FirstLinePos + 5,
                                         Search_String => "line",
                                         String_Found  => LineFound,
                                         String_Start  => LinePosition);
         --# end accept;
         LineNumber := ExtractLineNumberAtPosition (Line, LinePosition + 5);
      end if;

      --# accept F, 33, DummyPosition, "DummyPosition unused here" &
      --#        F, 33, LineFound,     "LineFound unused here";
      return LineNumber;
   end ExtractLastLineInRange;

   ---------------------------------------------------------------------


begin -- ProcessNewRangeLine
   NewStartLine := ExtractFirstLineInRange (Line);

   if NewStartLine = Refinement_Or_Inheritance_VC then
      NewEndLine := Refinement_Or_Inheritance_VC;
   else
      NewEndLine := ExtractLastLineInRange (Line);
   end if;

   NewEndLinePointType := VCDetails.PathEndToPathType (Line);

   NewVCInfo := VCInfoType'(StartLine            => NewStartLine,
                            EndLine              => NewEndLine,
                            EndLinePointType     => NewEndLinePointType,
                            NumberOfVCs          => 0,
                            Valid                => True,
                            FileType             => VCInfo.FileType,
                            AnyVCsPrinted        => False,
                            ThisStartLinePrinted => False);

   VCInfo := NewVCInfo;
end ProcessNewRangeLine;
