-- $Id: pathformatter.adb 14621 2009-10-28 13:48:23Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--To provide a standardised file name format which is platform independent    --
--when the -plain option is chosen.                                           --
--                                                                            --
--------------------------------------------------------------------------------
with CommandLine;
package body PathFormatter
is
   function Format (RawFileName : ELStrings.T)
      return ELStrings.T
   is
      WorkingDir : ELStrings.T;
      Result     : ELStrings.T;
   begin
      if CommandLine.Data.PlainOutput then
         -- strip the working directory off the start of VCFileName
         WorkingDir := CommandLine.Data.StartDirectory;
         Result := ELStrings.Section
           (E_Str     => RawFileName,
            Start_Pos => ELStrings.Get_Length (E_Str => WorkingDir) + 1,
            Length    => ELStrings.Get_Length (E_Str => RawFileName) - ELStrings.Get_Length (E_Str => WorkingDir));

         -- Convert back slash directory separators to forward slashes
         Result := ELStrings.Translate (E_Str     => Result,
                                        From_Char => '\',
                                        To_Char   => '/');
      else
         Result := RawFileName;
      end if;
      return Result;
   end Format;
end PathFormatter;
