-- $Id: oscommandline.ads 14621 2009-10-28 13:48:23Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Platform dependent package to read the command line given to the program    --
--and return it as a single string                                            --
--                                                                            --
--------------------------------------------------------------------------------

with ELStrings;

--# inherit EStrings,
--#         ELStrings,
--#         OSFiling;

package OSCommandLine
--# own State;
--# initializes State;
is

   type DataType is record
      Valid      : Boolean;
      ReportFile : ELStrings.T;
      -- defaults to <start directory>.sum

      StartDirectory   : ELStrings.T;
      -- defaults to current directory

      AnalyseVCs       : Boolean;
      AnalysePFs       : Boolean;
      AnalyseProofLog  : Boolean;
      VersionRequested : Boolean; -- -v on the command line
      IgnoreDates      : Boolean; -- -i on the command line
      PlainOutput      : Boolean; -- -p on the command line
      XML              : Boolean; -- -x on the command line
      ShortSummary     : Boolean; -- -s on the command line
      --  Defaults to  ShortSummary = False, i.e., a full summary.

      OutputPercentUndischarged : Boolean;
   end record;

   DefaultDataType : constant DataType := DataType'(
                        Valid                     => True,
                        ReportFile                => ELStrings.Empty_String,
                        StartDirectory            => ELStrings.Empty_String,
                        AnalyseVCs                => True,
                        AnalysePFs                => False,
                        AnalyseProofLog           => True,
                        PlainOutput               => False,
                        VersionRequested          => False,
                        IgnoreDates               => False,
                        XML                       => False,
                        ShortSummary              => False,
                        OutputPercentUndischarged => True);

   -- Returns character that precedes command line options
   function SwitchCharacter return Character;

   procedure Read (Switches : out DataType);
   --# global in State,
   --#           OSFiling.FileStructure;
   --# derives Switches from State, OSFiling.FileStructure;

   -- Takes a file path and directory and returns a path consisting of the file relative to the directory.
   -- If the file is specified with an absolute path then that path is returned and InputDir is ignored.
   procedure Normalize_Pathname (InputFile  : in     ELStrings.T;
                                 InputDir   : in     ELStrings.T;
                                 ResultPath :    out ELStrings.T);
   --# derives ResultPath from InputFile, InputDir;

end OSCommandLine;
