-- $Id: findfiles.ads 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Package for reading the file structure on the disc. This package is         --
--OS independent, and calls OSDirectory.Scan to perform the actual directory  --
--scan.                                                                       --
--                                                                            --
--                                                                            --
--------------------------------------------------------------------------------
with ELStrings;

--# inherit ELStrings,
--#         FatalErrors,
--#         FileDetails,
--#         FileHeap,
--#         Heap,
--#         OSDirectory,
--#         OSFiling;

package FindFiles
is
   procedure Scan (StartDirectory : in ELStrings.T);
   --# global in     OSFiling.FileStructure;
   --#        in out FatalErrors.State;
   --#           out FileHeap.State;
   --# derives FatalErrors.State from *,
   --#                                OSFiling.FileStructure,
   --#                                StartDirectory &
   --#         FileHeap.State    from OSFiling.FileStructure,
   --#                                StartDirectory;
end FindFiles;
