-- $Id: banner.ads 11367 2008-10-07 15:47:17Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


--------------------------------------------------------------------------------
--Synopsis:                                                                   --
--                                                                            --
--Produce the banner(s) to display on the screen and in the report file for   --
--the Semantic Analysis Summary Tool                                          --
--------------------------------------------------------------------------------
with SPARK_IO;
--# inherit CommandLine,
--#         ELStrings,
--#         SPARK_IO,
--#         Version,
--#         XMLSummary;
package Banner
is

   LenBanner                   : constant Integer := 79;
   subtype TypBannerRange      is Integer range 1 .. LenBanner;
   subtype TypBannerLine       is String (TypBannerRange);


   function MinorSeparatorLine return TypBannerLine;

   function MajorSeparatorLine return TypBannerLine;

   function EndOfReportMarker return TypBannerLine;


   procedure FinishReport (File : in SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in out SPARK_IO.File_sys;
   --#        in out XMLSummary.State;
   --# derives SPARK_IO.File_sys from *,
   --#                                CommandLine.Data,
   --#                                File,
   --#                                XMLSummary.State &
   --#         XMLSummary.State  from *,
   --#                                CommandLine.Data;

   procedure Screen;
   --# global in     CommandLine.Data;
   --#        in out SPARK_IO.File_sys;
   --# derives SPARK_IO.File_sys from *,
   --#                                CommandLine.Data;

   procedure ReportVersion;
   --# global in out SPARK_IO.File_sys;
   --#        in     CommandLine.Data;
   --# derives SPARK_IO.File_sys from *,
   --#                                CommandLine.Data;

   procedure Report (File : in SPARK_IO.File_Type);
   --# global in     CommandLine.Data;
   --#        in out SPARK_IO.File_sys;
   --#        in out XMLSummary.State;
   --# derives SPARK_IO.File_sys from *,
   --#                                CommandLine.Data,
   --#                                File,
   --#                                XMLSummary.State &
   --#         XMLSummary.State  from *,
   --#                                CommandLine.Data;

end Banner;
