-- $Id: xmlreport.ads 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with EStrings;
with ELStrings;
with SPARK_IO;
with SPARK_XML;

--# inherit ELStrings,
--#         EStrings,
--#         FileSystem,
--#         SPARK_IO,
--#         SPARK_XML,
--#         SystemErrors;

package XMLReport
--# own State;
is

   type Sections is (SReport,
                     SPrologue,
                     SCommandline,
                     SCompilerData,
                     SCyclicRequirements,
                     SIndexes,
                     STargetConfig,
                     SMessages,
                     SMetaFiles,
                     SUnitsNotFound,
                     SWarningsConfig,
                     SResults,
                     SListing,
                     SUnitsInFile,
                     SJustifications,
                     SFullJustifications
                    );

   MaxMetaFileDepth : constant Integer := 50;

   subtype MetaFileId is SPARK_XML.TagDepth;

   function FilterString (Str : in EStrings.T) return EStrings.T;

   function FilterLongString (Str : in ELStrings.T) return ELStrings.T;


   procedure Init;
   --# global out State;
   --# derives State from ;




   -- Producers for simple container tags.
   -- These have no attributes of their own and only contain other tags.
   -- The only exception is the Listing tag, which contains large amounts of text,
   -- and is also included.

   procedure StartSection (Section : in Sections;
                           Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State &
   --#         State             from *,
   --#                                Section;


   procedure EndSection (Section : in Sections;
                         Report  : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                Section,
   --#                                State &
   --#         State             from *,
   --#                                Section;

   -- Simple tags, ones whose opening and closing tags are generated
   -- at the same time.  E.g. <filename>file.txt</filename>
   procedure Filename (Plain_Output : in     Boolean;
                       File         : in out EStrings.T);
   --# global in out State;
   --# derives File  from *,
   --#                    Plain_Output,
   --#                    State &
   --#         State from *;

   procedure Index (Plain_Output : in     Boolean;
                    Idx          : in out EStrings.T);
   --# global in out State;
   --# derives Idx   from *,
   --#                    Plain_Output,
   --#                    State &
   --#         State from *;

   procedure CompilerItem (Item   : in EStrings.T;
                           Val    : in EStrings.T;
                           Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Val &
   --#         State             from *,
   --#                                Item;

   procedure LongCompilerItem (Item   : in EStrings.T;
                               Val    : in ELStrings.T;
                               Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Item,
   --#                                Report,
   --#                                State,
   --#                                Val &
   --#         State             from *,
   --#                                Item;

   procedure Suppressed (Item : in out EStrings.T);
   --# global in out State;
   --# derives Item,
   --#         State from *,
   --#                    State;

   procedure SuppressedPragma (Item : in out EStrings.T);
   --# global in out State;
   --# derives Item,
   --#         State from *,
   --#                    State;

   procedure Option (Opt : in out EStrings.T);
   --# global in out State;
   --# derives Opt,
   --#         State from *,
   --#                    State;

   procedure Unit (Name   : in EStrings.T;
                   Typ    : in EStrings.T;
                   Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State,
   --#                                Typ &
   --#         State             from *,
   --#                                Name,
   --#                                Typ;


   -- Ada Units in a file.
   procedure AdaUnit (Name       : in EStrings.T;
                      Typ        : in EStrings.T;
                      UnitStatus : in EStrings.T;
                      Report     : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State,
   --#                                Typ,
   --#                                UnitStatus &
   --#         State             from *,
   --#                                Name,
   --#                                Typ,
   --#                                UnitStatus;



   -- Message construction.

   procedure StartMessage (Class  : in EStrings.T;
                           Code   : in Integer;
                           Line   : in Integer;
                           Offset : in Integer;
                           Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Class,
   --#                                Code,
   --#                                Line,
   --#                                Offset,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Class,
   --#                                Code,
   --#                                Line,
   --#                                Offset;



   procedure Symbol (Sym    : in EStrings.T;
                     SymNum : in Integer;
                     Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State,
   --#                                Sym,
   --#                                SymNum &
   --#         State             from *,
   --#                                SymNum;



   procedure EndMessage (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   -- Metafile contruction

   procedure StartMetaFile (Name   : in     EStrings.T;
                            Report : in     SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Name,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Name;



   procedure EndMetaFile (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   -- Results Section contents

   procedure Start_File (Plain_Output : in Boolean;
                         F_Name       : in EStrings.T;
                         Report       : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                F_Name,
   --#                                Plain_Output,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                F_Name,
   --#                                Plain_Output;


   procedure EndFile (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;


   procedure BriefJustifications (Matched   : in Natural;
                                  Unmatched : in Natural;
                                  Report    : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Matched,
   --#                                Report,
   --#                                State,
   --#                                Unmatched &
   --#         State             from *,
   --#                                Matched,
   --#                                Unmatched;

   procedure StartFullJustification (Class     : in EStrings.T;
                                     Code      : in Integer;
                                     LineFrom  : in Integer;
                                     LineTo    : in EStrings.T;
                                     MatchNo   : in Integer;
                                     MatchLine : in Integer;
                                     Report    : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Class,
   --#                                Code,
   --#                                LineFrom,
   --#                                LineTo,
   --#                                MatchLine,
   --#                                MatchNo,
   --#                                Report,
   --#                                State &
   --#         State             from *,
   --#                                Class,
   --#                                Code,
   --#                                LineFrom,
   --#                                LineTo,
   --#                                MatchLine,
   --#                                MatchNo;

   procedure EndFullJustification (Report : in SPARK_IO.File_Type);
   --# global in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Report,
   --#                                State &
   --#         State             from *;

end XMLReport;
