-- $Id: systemerrors.ads 13645 2009-06-25 13:57:33Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with EStrings;
--# inherit EStrings,
--#         ScreenEcho,
--#         SPARK_IO;
package SystemErrors
is
   type SysErrType is (StringTableOverflow,
                       SyntaxTreeOverflow,
                       ParseStackOverflow,
                       SymbolTableOverflowStatic,
                       SymbolTableOverflowDynamic,
                       InvalidSyntaxTree,
                       InvalidSymbolTable,
                       EmptyHeap,
                       RelationStackUnderflow,
                       RelationStackOverflow,
                       InvalidInit,
                       ErrorPositionWrong,
                       ExpressionStackCorrupt,
                       ExpressionStackUnderflow,
                       ExpressionStackOverflow,
                       TypeContextStackCorrupt,
                       TypeContextStackUnderflow,
                       TypeContextStackOverflow,
                       ListOverflowInExpression,
                       ListOverflowInDependencyClause,
                       ListOverflowInProcedureCall,
                       CaseStackUnderflow,
                       CaseStackOverflow,
                       VCGGraphSizeExceeded,
                       VCGHeapIsExhausted,
                       VCGHeapIsCorrupted,
                       RefListKeyCellMissing,
                       FlowAnalyserExpressionLimit,
                       CaseStatementNestingLimit,
                       ErrorHandlerTemporaryFiles,
                       ErrorHandlerSource,
                       DiskFullError,
                       MathError,
                       TooManyNestedArrays,
                       TooManyNestedRecords,
                       ContextUnitStackOverflow,
                       ContextUnitStackUnderflow,
                       ContextFileHeapOverflow,
                       ContextUnitHeapOverflow,
                       TooManyFileLines,
                       IndexStackFull,
                       IndexComponentListFull,
                       TooManyErrors,
                       WarningNameTooLong,
                       UnitNameInIndexTooLong,
                       FileNameInIndexTooLong,
                       TooManySuppressedWarnings,
                       UnitNestingTooDeep,
                       StatementStackUnderflow,
                       StatementStackOverflow,
                       WfCompilationUnitStackOverflow,
                       WfCompilationUnitStackUnderflow,
                       TooManyFlowAnalyserExpressions,
                       TooManyParamsInProcedureCall,
                       StatisticsUsageGreaterThanTableSize,
                       AggregateStackUnderFlow,
                       AggregateStackOverFlow,
                       MetaFileStackOverflow,
                       LexStackOverflow,
                       LexStackUnderflow,
                       ComponentManagerOverflow,
                       ComponentErrorOverflow,
                       SyntaxTreeWalkError,
                       PreconditionFailure,
                       PostConditionFailure,
                       AssertionFailure,
                       UnimplementedFeature,
                       XMLSchemaError,
                       XMLGenerationError,
                       IllegalXMLGenerationAttempt,
                       StringOverFlow,
                       QueueOverflow,
                       XRefTableFull,
                        -- Add additional specific entries here...
                       OtherInternalError);



   type StartErrType is (NoLmgrd,
                         NoLicenceFile,
                         CantReadLicence,
                         Expired,
                         TooManyExaminerUsers,
                         TooManyRavenSPARKUsers,
                         TooManyVDSUsers,
                         TooManyAdaMagicUsers,
                         CorruptedLicence,
                         ObsoleteLicence,
                         UnexpectedFLEX,
                         WrongMachine,
                         WrongExaminerLicenceFile,
                         WrongRavenSPARKLicenceFile,
                         WrongVDSLicenceFile,
                         WrongAdaMagicLicenceFile,
                         NoSpex);

   -- Proof function can be asserted true and, on paths where SystemErrors is called
   -- this will appear in hypotheses; this helps understand what is going on.

   --# function Halted return Boolean;

   procedure StartupError (StartErr  : in StartErrType;
                           Version   : in EStrings.T;
                           FlexError : in Integer);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                FlexError,
   --#                                StartErr,
   --#                                Version;
   --# post Halted and -- this helps us understand VCs where SystemError called
   --#      False;     -- this ensures that such paths are provable by contradiction


   -- Raises SysErr with Msg
   procedure FatalError (SysErr : in SysErrType; Msg : in String);
   --# derives null from Msg,
   --#                   SysErr;
   --# post Halted and -- this helps us understand VCs where SystemError called
   --#      False;     -- this ensures that such paths are provable by contradiction


   -- if C if False, then Raises SysErr with Msg
   -- if C is True,  then returns
   procedure RTAssert (C : in Boolean; SysErr : in SysErrType; Msg : in String);
   --# derives null from C,
   --#                   Msg,
   --#                   SysErr;
   --# post C or (not C and Halted and False);

end SystemErrors;
