-- $Id: stmtstack.ads 13007 2009-04-16 12:32:09Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--------------------------------------------------------------------------------
--  StmtStack
--
--  Purpose:
--   StmtStack is an Abstract State Machine that provides a simple
--   stack of entries.  Each entry contains a pair of values:
--
--    StmtNumber - the number of a BPG statement node, with
--                 ZERO indicating a null entry, and a positive
--                 number interpreted as a value of type Graph.MatrixIndex
--
--    Kind - the class of statement, as defined by ArcKind below.
--
--  Clients:
--   The StmtStack is used by the (iterative) traversal algorithm in
--   DAG.BuildGraph to keep track of the nesting of statement forms in the
--   syntax tree as the BPG is produced.
--
--  Use:
--   See DAG.BuildGraph
--
--  Extension:
--   None planned at present.
--------------------------------------------------------------------------------

with ExaminerConstants;
--# inherit ExaminerConstants,
--#         SystemErrors;
package StmtStack
--# own S : StmtStacks;
--# initializes S;
is

   type ArcKind is (Elementary,
                    IfStart,
                    IfTrueBranch,
                    IfFalseBranch,
                    CaseStart,
                    CaseBranch,
                    CaseExit,
                    LoopStart,
                    LoopExit);

   type StmtRecord is record
      StmtNmbr : Natural;
      Kind     : ArcKind;
   end record;
   subtype StmtRange is Integer range 0 .. ExaminerConstants.StmtStackSize;


   type    StmtVector is array (StmtRange) of StmtRecord;
   type    StmtStacks is record
      Vector  : StmtVector;
      Pointer : StmtRange;
   end record;


   function IsEmpty return Boolean;
   --# global in S;

   function Top return StmtRecord;
   --# global in S;

   procedure Clear;
   --# global out S;
   --# derives S from ;

   -- Pop, but fatal error if underflow
   procedure Pop;
   --# global in out S;
   --# derives S from *;

   -- Push, but fatal error if overflow
   procedure Push (R : in StmtRecord);
   --# global in out S;
   --# derives S from *,
   --#                R;

   -- Print the current state of the stack to Standard_Output via Debug package,
   -- preceding by the given Msg
   procedure Dump_Stack (Msg : in String);
   --# global in S;
   --# derives null from S, Msg;
end StmtStack;
