-- $Id: sparklex.ads 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Ada.Characters.Latin_1,
     SPARK_IO,
     SPSymbols,
     LexTokenManager,
     EStrings;

use type SPSymbols.SPSymbol;
use type LexTokenManager.Line_Numbers;

--# inherit Ada.Characters.Handling,
--#         Ada.Characters.Latin_1,
--#         CommandLineData,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SPARK_IO,
--#         SPSymbols,
--#         SystemErrors;
package SparkLex
   --# own CurrLine;
is

   type LineContext is private;

   NullLineContext : constant LineContext;

   procedure ClearLineContext;
   --# global out CurrLine;
   --# derives CurrLine from ;

   procedure StoreLineContext (FileLine : out LineContext);
   --# global in CurrLine;
   --# derives FileLine from CurrLine;

   procedure RestoreLineContext (FileLine : in LineContext);
   --# global out CurrLine;
   --# derives CurrLine from FileLine;

   -- Returns True iff ExStr is an FDL reserved word
   function CheckFDL_RW (ExStr : EStrings.T) return Boolean;

   -- Scan ProgText and return next token found with class Token
   -- and value LexVal.  PunctToken is True iff the scanned token
   -- is deemed to be a "punctutation token" which can be ignored
   -- by the parser.
   --
   -- The exact list of "Punctutation Tokens" is defined in
   -- SPARKLex.Lex.IsPunctToken
   procedure ExaminerLex (ProgText   : in     SPARK_IO.File_Type;
                          Token      :    out SPSymbols.SPTerminal;
                          LexVal     :    out LexTokenManager.Lex_Value;
                          PunctToken :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out CurrLine;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives CurrLine,
   --#         ErrorHandler.ErrorContext,
   --#         LexTokenManager.State,
   --#         LexVal,
   --#         PunctToken,
   --#         SPARK_IO.File_Sys,
   --#         Token                     from CommandLineData.Content,
   --#                                        CurrLine,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        ProgText,
   --#                                        SPARK_IO.File_Sys;

   -- This version behaves as ExaminerLex, but _allows_ identifiers
   -- beginning with $ to allow for pre-processing and macro-substitution
   -- of such identifiers by tools such as GNATPREP.
   procedure SPARKFormatLex (ProgText   : in     SPARK_IO.File_Type;
                             Token      :    out SPSymbols.SPTerminal;
                             LexVal     :    out LexTokenManager.Lex_Value;
                             PunctToken :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in out CurrLine;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives CurrLine,
   --#         ErrorHandler.ErrorContext,
   --#         LexTokenManager.State,
   --#         LexVal,
   --#         PunctToken,
   --#         SPARK_IO.File_Sys,
   --#         Token                     from CommandLineData.Content,
   --#                                        CurrLine,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        ProgText,
   --#                                        SPARK_IO.File_Sys;


   -- Returns True if Token1 and Token2 are both
   --    Delimiters (such as operators, [ ], and %)
   -- or both Numbers (integers, real, based literals etc.)
   -- or both Character or String literals
   -- or both Identifiers
   -- or both Reserved Words
   -- or both "Others" (not falling into any of the catogories above)
   function SimilarTokens (Token1, Token2 : SPSymbols.SPTerminal) return Boolean;

private

   type ProgramContext is (InAda, InAnnotation);

   type AnnotationContext is (StartAnnotation, MidAnnotation, EndedAnnotation);

   subtype Line_Lengths is Integer range 0 .. 255;

   type Line is array (Line_Lengths) of Character;

   type LineContext is
      record
         Context       : ProgramContext;
         AnnoContext   : AnnotationContext;
         LineNo        : LexTokenManager.Line_Numbers;
         LineLength,
         LastTokenPos,
         CurrPos,
         LookaheadPos  : Line_Lengths;
         Conts         : Line;
      end record;

   NullLineContext : constant LineContext :=
     LineContext'(Context      => InAda,
                  AnnoContext  => StartAnnotation,
                  LineNo       => LexTokenManager.Line_Numbers'First,
                  LineLength   => Line_Lengths'First,
                  LastTokenPos => Line_Lengths'First,
                  CurrPos      => Line_Lengths'First,
                  LookaheadPos => Line_Lengths'First,
                  Conts        => Line'(others => Ada.Characters.Latin_1.NUL));
end SparkLex;
