-- $Id: sli-io.ads 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with EStrings;
with ELStrings;

--  Manage the IO for the SLI file.
--# inherit EStrings,
--#         ELStrings;

private package SLI.IO
--# own out Stream_Buffer;
is

   type File_Status is (Ok, Status_Error, Name_Error, Use_Error, Device_Error);

   --  Create a SLI file called Name_Of_File.SLI.
   procedure Create_File (Name_Of_File : in     EStrings.T;
                          Status       :    out File_Status);
   --# global out Stream_Buffer;
   --# derives Status,
   --#         Stream_Buffer from Name_Of_File;

   --  Close the SLI file.
   procedure Close;
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from ;

   --  Write a character (Item) in the SLI file.
   procedure Put_Char (Item : in Character);
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from Item;

   --  Write a string (Item) in the SLI file.
   procedure Put_String (Item : in String);
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from Item;

   --  Write an integer (Item) in the SLI file.
   procedure Put_Integer (Item : in Integer);
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from Item;

   --  Write a new line in the SLI file.
   procedure New_Line;
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from ;

   --  Write a line (Item) in the SLI file.
   procedure Put_Line (Item : in String);
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from Item;

   --  Write a string (EStr) in the SLI file.
   procedure E_Strings_Put_String (E_Str : in ELStrings.T);
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from E_Str;

   --  Write a line (EStr) in the SLI file.
   procedure E_Strings_Put_Line (E_Str : in ELStrings.T);
   --# global out Stream_Buffer;
   --# derives Stream_Buffer from E_Str;

end SLI.IO;
