-- $Id: simplelists.ads 15674 2010-01-20 16:17:20Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--------------------------------------------------------------------------------
--  SimpleLists
--
--  Purpose:
--   Provides an ADT for a bounded, unordered list of Naturals,
--  duplicates permitted.  The max size of a list is defined
--  by ExaminerConstants.SimpleListsSize
--
--  Clients:
--   Used by Sem (specifically wf_proc_call) to match lists for formal
--  and actual parameters.
--
--  Use:
--   Declare then Initialize with procedure Init.
--
--  Extension:
--   None planned.
--------------------------------------------------------------------------------

with ExaminerConstants;

--# inherit ExaminerConstants;
package SimpleLists
is
   type SimpleList is private;

   function NumberOfItems (List : SimpleList) return Natural;

   procedure Init (List : out SimpleList);
   --# derives List from ;
   --# post NumberOfItems (List) = 0;

   procedure AddItem (Item : in     Natural;
                      List : in out SimpleList;
                      Ok   :    out Boolean);
   --# derives List from *,
   --#                   Item &
   --#         Ok   from List;
   --# post (Ok <-> NumberOfItems (List~) < ExaminerConstants.SimpleListsSize) and
   --#      (Ok  -> NumberOfItems (List) = NumberOfItems (List~) + 1);

   procedure GetItem (List     : in     SimpleList;
                      Position : in     Positive;
                      Item     :    out Natural;
                      Ok       :    out Boolean);
   --# derives Item,
   --#         Ok   from List,
   --#                   Position;
   --# post Ok <-> Position <= NumberOfItems (List);

private
   subtype Index is Integer range 0 .. ExaminerConstants.SimpleListsSize;
   type ListArrays is array (Index) of Natural;
   type SimpleList is record
      ListArray       : ListArrays;
      HighestOccupied : Index;
   end record;

end SimpleLists;
